/***************************************************************************
 begin                : Tue Mar 5 2002
 copyright            : (C) 2002 by Christian Hubinger
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORINTERFACE_H
#define KMFRULEEDITORINTERFACE_H
#include "kmyfirewallruleeditorinterface.h"

#include <qwidget.h>
#include <qptrlist.h>
#include <qstring.h>


/**Dialog for setting up interface
dependent rule options.
  *@author Christian Hubinger
  */

class IPTRule;

class KMFRuleEditorInterface : public KMyFirewallRuleEditorInterface {
	Q_OBJECT
public:
	KMFRuleEditorInterface( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorInterface();

	void loadRule( IPTRule* );

public slots:    // Public slots
	void slotCheckConfig();
	void slotOk();
	void slotReadConfig();
	void slotHelp();
	void reject();

private:
	IPTRule* m_rule;

signals:
	void sigAddRuleOpt( QString *, QPtrList<QString> * );
	void sigHideMe();
};

#endif
