#include "MainApp.h"
#include <kmenubar.h>
#include <qkeycode.h>
#include <kmenubar.h>
#include <kaction.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <qtextstream.h>
#include <qmenudata.h>
#include <kpopupmenu.h>
#include <qlayout.h>
#include "stringres.h"
#include "MainWindow.h"
#include "kmysqladmin/setup/setupdlg.h"
#include "kmysqladmin/helpers/helpers.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "kmysqladmin/setup/settings.h"
#include <klocale.h>
#include <iostream>

#include "resource.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define Inherited KMainWindow

using namespace std;

CMainApp::CMainApp(const char* name,bool _first)
        :Inherited(0,name ),CSendMessage()
{
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(124);
    setCaption(head);
    server_actions = 0;

    MainWidget = new CMainWindow( this, "MainWidget" );
    MainWidget->set_msg_ptr(this);

    connect(MainWidget,SIGNAL(connected(const char*)),this,SLOT(connected_to_server(const char*)));
    connect(MainWidget,SIGNAL(disconnected()),this,SLOT(disconnected_from_server()));
    connect(this,SIGNAL(quickConnect(const QString& )),MainWidget,SLOT(ConnectQuick(const QString&)));
    connect(MainWidget,SIGNAL(quickConsChanged()),this,SLOT(setup_quickies()));
    setCentralWidget(MainWidget);

    initActions();
    initMenu();
    initToolbar();
    disconnected_from_server();
    setMinimumSize( 370, 190 );
    setMaximumSize( 32767, 32767 );
    KConfig * k = KGlobal::config();
    k->setGroup("common");
    int w,h;
    QString ws,hs;
    ws = k->readEntry("width","0");
    hs = k->readEntry("height","0");
    w = ws.toInt();
    h = hs.toInt();
    if (w && h) {
        if ( (h-10) > 0)
            MainWidget->resize(w,h-10);
        resize(w,h);
    }
    if (_first) {
        if (kapp->isRestored()) {
            MainWidget->RestoreLastConnect();
        } else {
        }
    }
}

void CMainApp::clearActions()
{
    QMap<int,KAction*>::Iterator it;
    for (it=action_list.begin();it!=action_list.end();++it) {
        it.data()->unplugAll();
        delete it.data();
    }
    action_list.clear();
    if (server_actions) delete server_actions;
}

void CMainApp::initActions()
{
    clearActions();

    server_actions = new KActionCollection(this);

    action_list[ID_CONNECT]        =new KAction(GET_TEXT(153),QString("connect_creating"),KShortcut(QKeySequence(CTRL+Key_C)),MainWidget,SLOT(connectSql()),this);
    action_list[ID_DISCONNECT]     =new KAction(GET_TEXT(47) ,QString("connect_no"),KShortcut(QKeySequence(CTRL+Key_D)),MainWidget,SLOT(disconnectSql()),this);
    action_list[ID_RESTORE_LOGIN]  =new KAction(GET_TEXT(145),QString("redo"),KShortcut(),MainWidget,SLOT(RestoreLastConnect()),this);
    action_list[ID_FLUSH_OUTPUT]   =new KAction(GET_TEXT(48),QString("eraser"),KShortcut(),MainWidget,SLOT(clearOutput()),this);
    action_list[ID_FILE_OUTPUT]    =new KToggleAction(GET_TEXT(49),QString("filesaveas"),KShortcut(CTRL+Key_S),this,SLOT(set_LogFileName()),this);
    action_list[ID_FILE_NEW_WINDOW]=new KAction(GET_TEXT(122),QString("window_new"),KShortcut(CTRL+Key_N),this,SLOT(new_window()),this);
    action_list[ID_FILE_CLOSE]     =new KAction(GET_TEXT(123),QString("fileclose"),KShortcut(CTRL+Key_W),this,SLOT(windowClose()),this);
    action_list[ID_FILE_QUIT]      =new KAction(GET_TEXT(149),QString("exit"),KShortcut(CTRL+Key_Q),this,SLOT(raus_hier()),this);

    action_list[ID_FLUSH_CACHE]    =new KAction(GET_TEXT(52),QString("rebuild"),KShortcut(),MainWidget,SLOT(flush_cache()),server_actions);
    action_list[ID_CLOSE_TABLES]   =new KAction(GET_TEXT(53),KShortcut(),MainWidget,SLOT(close_tables()),server_actions);
    action_list[ID_NEW_LOG]        =new KAction(GET_TEXT(54),QString("filenew"),KShortcut(),MainWidget,SLOT(new_log()),server_actions);
    action_list[ID_REFRESH_ACCESS] =new KAction(GET_TEXT(55),QString("reload"),KShortcut(),MainWidget,SLOT(reload_grants()),server_actions);
    QString e_str = "&";e_str+=i18n(CStringRes::get_string(56));
    action_list[ID_SHUTDOWN]       =new KAction(e_str,QString("stop"),KShortcut(),MainWidget,SLOT(shutdown()),server_actions);

    action_list[ID_ACCESS_RIGHTS]  =new KAction(GET_TEXT(154),QString("access_rights"),KShortcut(),MainWidget,SLOT(accessControl()),server_actions);
    action_list[ID_STATUS]         =new KAction(GET_TEXT(155),QString("status"),KShortcut(),MainWidget,SLOT(dispStatus()),server_actions);
    action_list[ID_THREADS]        =new KAction(GET_TEXT(156),QString("threads"),KShortcut(),MainWidget,SLOT(view_threads()),server_actions);
    action_list[ID_SQL_EDIT]       =new KAction(GET_TEXT(150),QString("edit"),KShortcut(CTRL+Key_E),MainWidget,SLOT(sql_Edit()),server_actions);
    action_list[ID_SEARCH_TABLE]   =new KAction(GET_TEXT(90),QString("viewtab"),KShortcut(CTRL+Key_B),MainWidget,SLOT(browseTables()),server_actions);
    action_list[ID_NEW_DB]         =new KAction(GET_TEXT(157),QString("newdb"),KShortcut(),MainWidget,SLOT(createDB()),server_actions);
    action_list[ID_NEW_TABLE]      =new KAction(GET_TEXT(3),QString("newtab"),KShortcut(),MainWidget,SLOT(createTable()),server_actions);
    action_list[ID_MODIFY_TABLE]   =new KAction(GET_TEXT(114),QString("altertab"),KShortcut(),MainWidget,SLOT(alterTable()),server_actions);
    action_list[ID_REN_TABLE]      =new KAction(GET_TEXT(110),QString("tab_duplicate"),KShortcut(),MainWidget,SLOT(rename_table()),server_actions);
    action_list[ID_DEL_TABLE]      =new KAction(GET_TEXT(51),QString("edittrash"),KShortcut(),MainWidget,SLOT(drop_table()),server_actions);

    action_list[ID_CONFIGURE]      =new KAction(GET_TEXT(151),QString("configure"),KShortcut(),this,SLOT(layout_setup()),this);
    action_list[ID_PROFILES]       =new KAction(GET_TEXT(163),KShortcut(),MainWidget,SLOT(connection_profiles()),this);
    action_list[ID_SHOW_LOG]       =new KAction(GET_TEXT(164),QString("logviewer"),KShortcut(),MainWidget,SLOT(showLog()),this);
}

void CMainApp::initToolbar()
{
    action_list[ID_CONNECT]->plug(toolBar());
    toolBar()->insertSeparator();

    bool compact = GlobalSettings.getCompactLayout();
    action_list[ID_SHOW_LOG]->plug(toolBar());
    if (!compact) {
        action_list[ID_SHOW_LOG]->setEnabled(false);
    }
    action_list[ID_SEARCH_TABLE]->plug(toolBar());
    toolBar()->insertSeparator();

    action_list[ID_ACCESS_RIGHTS]->plug(toolBar());
    action_list[ID_STATUS]->plug(toolBar());
    action_list[ID_THREADS]->plug(toolBar());
    toolBar()->insertSeparator();

    action_list[ID_SQL_EDIT]->plug(toolBar());
    toolBar()->insertSeparator();

    action_list[ID_NEW_DB]->plug(toolBar());
    action_list[ID_NEW_TABLE]->plug(toolBar());
    action_list[ID_MODIFY_TABLE]->plug(toolBar());
    toolBar()->insertSeparator();

    action_list[ID_CONFIGURE]->plug(toolBar());
}

void CMainApp::setup_quickies()
{
    quick_connects->clear();
    quick_map.clear();
    QStringList quickLogins = GlobalSettings.getConnectProfilesList();
    int id;
    for (unsigned int i = 0; i < quickLogins.count();++i) {
        id = quick_connects->insertItem(quickLogins[i]);
        quick_map[id]=quickLogins[i];
    }
}

void CMainApp::quick_selected(int aItem)
{
    if( quick_map.find(aItem)==quick_map.end()) return;
    QString current = quick_map[aItem];//quick_connects->text(aItem);
    if (current.isEmpty()) return;
    emit quickConnect(current);
}

void CMainApp::initMenu()
{
    MenuBar = menuBar();
    file = new KPopupMenu;

    id_map["connect"]=action_list[ID_CONNECT]->plug(file);
    id_map["disconnect"]=action_list[ID_DISCONNECT]->plug(file);
    id_map["last_connect"]=action_list[ID_RESTORE_LOGIN]->plug(file);

    file->insertSeparator();

    quick_connects = new KPopupMenu;
    id_map["quick_connects"]=file->insertItem("Quick connects",quick_connects);
    connect(quick_connects,SIGNAL(activated(int)),this,SLOT(quick_selected(int)));
    setup_quickies();
    file->insertSeparator();
    action_list[ID_FLUSH_OUTPUT]->plug(file);
    id_map["logfile"] = action_list[ID_FILE_OUTPUT]->plug(file);
    file->insertSeparator();

    action_list[ID_FILE_NEW_WINDOW]->plug(file);
    file->insertSeparator();

    action_list[ID_FILE_CLOSE]->plug(file);
    action_list[ID_FILE_QUIT]->plug(file);

    MenuBar->insertItem(i18n(CStringRes::get_string(109)),file);

    server_menu = new KPopupMenu;
    action_list[ID_FLUSH_CACHE]->plug(server_menu);
    action_list[ID_CLOSE_TABLES]->plug(server_menu);
    action_list[ID_NEW_LOG]->plug(server_menu);
    server_menu->insertSeparator();
    action_list[ID_REFRESH_ACCESS]->plug(server_menu);
    action_list[ID_SHUTDOWN]->plug(server_menu);
    server_menu->insertSeparator();

    action_list[ID_SHOW_LOG]->plug(server_menu);
    action_list[ID_ACCESS_RIGHTS]->plug(server_menu);
    action_list[ID_STATUS]->plug(server_menu);
    action_list[ID_THREADS]->plug(server_menu);
    server_menu->insertSeparator();
    action_list[ID_SQL_EDIT]->plug(server_menu);

    MenuBar->insertItem(i18n(CStringRes::get_string(161)),server_menu);

    db_menu = new KPopupMenu;
    action_list[ID_SEARCH_TABLE]->plug(db_menu);
    db_menu->insertSeparator();
    action_list[ID_NEW_DB]->plug(db_menu);
    db_menu->insertSeparator();

    action_list[ID_NEW_TABLE]->plug(db_menu);
    action_list[ID_MODIFY_TABLE]->plug(db_menu);
    action_list[ID_REN_TABLE]->plug(db_menu);
    action_list[ID_DEL_TABLE]->plug(db_menu);

    MenuBar->insertItem(i18n(CStringRes::get_string(57)),db_menu);
    setup_menu = new KPopupMenu;
    action_list[ID_CONFIGURE]->plug(setup_menu);
    action_list[ID_PROFILES]->plug(setup_menu);
    MenuBar->insertItem(i18n(CStringRes::get_string(146)),setup_menu);

    MenuBar->insertSeparator();

    KPopupMenu *help = helpMenu();
    MenuBar->insertItem(i18n(CStringRes::get_string(111)),help );
}

CMainApp::~CMainApp()
{
    clearActions();
    filepointer.close();
}

void CMainApp::append_message(const std::string&message)
{
    if (message.size()==0)
        return;
    MainWidget->append_message(message);
    if (filepointer.good()) {
        filepointer << message << "\n";
        filepointer.flush();
    }
}

void CMainApp::set_LogFileName()
{
    QString s;
    if (logfile.size()==0) {
        s = KFileDialog::getOpenFileName(0,"*.log");
        if (!s.isEmpty()) {
            logfile = s.latin1();
            filepointer.open(logfile.c_str(),ios::out|ios::app|ios::ate);
            if (!filepointer.good())
                logfile = "";
        }
    } else {
        logfile = "";
        filepointer.flush();
        filepointer.close();
    }
    ((KToggleAction*)action_list[ID_FILE_OUTPUT])->setChecked(logfile.empty()?0:1);
}

void CMainApp::setActionsEnabled(KActionCollection*which,bool how)
{
    if (!which) return;
    KActionPtrList li = which->actions();
    KActionPtrList::Iterator it = li.begin();
    for (;it!=li.end();++it) {
        (*it)->setEnabled(how);
    }
}

void CMainApp::disconnected_from_server()
{
    action_list[ID_CONNECT]->setEnabled(true);
    action_list[ID_DISCONNECT]->setEnabled(false);
    action_list[ID_RESTORE_LOGIN]->setEnabled(true);

    file->setItemEnabled(id_map["quick_connects"],true);

    setActionsEnabled(server_actions,false);
    QString head = GET_TEXT(125);head+=" - ";head+=GET_TEXT(124);
    setCaption(head);
}

void CMainApp::connected_to_server(const char*msg)
{
    action_list[ID_CONNECT]->setEnabled(false);
    action_list[ID_DISCONNECT]->setEnabled(true);
    action_list[ID_RESTORE_LOGIN]->setEnabled(false);
    file->setItemEnabled(id_map["quick_connects"],false);

    setActionsEnabled(server_actions,true);
    QString head = GET_TEXT(125);head+=" - ";
    if (msg) {
        head+=msg;
    } else {
        head+="connected";
    }
    setCaption(head);
}

void CMainApp::new_window()
{
    CMainApp*dlg = new CMainApp;
    dlg->show();
}

void CMainApp::raus_hier()
{
    MainWidget->close();
    close();
}

void CMainApp::windowClose()
{
    MainWidget->close();
    close();
}

bool CMainApp::queryExit()
{
    return true;
}

bool CMainApp::queryClose()
{
    queryExit();
    KConfig*k = KGlobal::config();
    k->setGroup("common");
    int w,h;
    w = width();
    h = height();
    QString s;
    s.setNum(w);
    k->writeEntry("width",s);
    s.setNum(h);
    k->writeEntry("height",s);
    MainWidget->close();
    return true;
}

void CMainApp::layout_setup()
{
    CSetupDlg layout_setup;
    bool compact = GlobalSettings.getCompactLayout();
    if (layout_setup.exec()) {
        QFont fix_font = layout_setup.fixed_font();
        QFont nprop_font = layout_setup.nonprop_font();
        GlobalSettings.set_fixed_font(fix_font);
        GlobalSettings.set_nprop_font(nprop_font);
        GlobalSettings.StatusPolltime(layout_setup.StatusPolltime());
        GlobalSettings.ThreadPolltime(layout_setup.ThreadPolltime());
        GlobalSettings.setBlobimages(layout_setup.Blobimage(),layout_setup.Blobscale(),
            layout_setup.Blobwidth(),layout_setup.Blobheight());
        GlobalSettings.setRealmultiLines(layout_setup.dispMultiline());
        bool cnew = layout_setup.compactLayout();
        if (cnew != compact) {
            GlobalSettings.setCompactLayout(cnew);
            action_list[ID_SHOW_LOG]->setEnabled(cnew);
        }
        GlobalSettings.setOldBrowser(layout_setup.oldBrowser());
        GlobalSettings.make_settings_changed_signal();
    }
}
