// -*-Mode: C++;-*-
#ifndef CMainApp_included
#define CMainApp_included

#include <qmap.h>
#include <iostream>
#include <fstream>

#include "kmainwindow.h"
#include "sendmessage.h"

class CMainWindow;
class KPopupMenu;
class KAction;
class KActionCollection;
class KMenuBar;

class CMainApp : public KMainWindow,public CSendMessage
{
    Q_OBJECT

public:
    CMainApp ( const char* name = NULL,bool _first = false );

    virtual ~CMainApp();
    virtual void append_message(const std::string&message);

protected:
    KPopupMenu*file;
    KPopupMenu*quick_connects;
    KPopupMenu*db_menu;
    KPopupMenu*server_menu;
    KPopupMenu*setup_menu;
    KPopupMenu*dialogs_menu;

    std::string logfile;
    std::ofstream filepointer;
    KMenuBar*MenuBar;
    CMainWindow* MainWidget;
    QMap<std::string,int> id_map;
    QMap<int,QString> quick_map;
    QMap<int,KAction*> action_list;
    KActionCollection*server_actions;

    virtual void initToolbar();
    virtual void initMenu();
    virtual void initActions();
    virtual void clearActions();

    virtual void setActionsEnabled(KActionCollection*,bool);

protected slots:
    void new_window();
    void raus_hier();
    void set_LogFileName();
    void connected_to_server(const char*);
    void disconnected_from_server();
    bool queryExit();
    bool queryClose();
    void layout_setup();
    void quick_selected(int);

public slots:
    void windowClose();
    void setup_quickies();
signals:
    void quickConnect(const QString&);
};
#endif // CMainApp_included
