#include <kapp.h>
#include <kconfig.h>
#include <iostream>
#include <kmessagebox.h>
#include <klocale.h>
#include <qmessagebox.h>
#include <kglobal.h>
#include <qtextview.h>
#include <qwidgetstack.h>

#include "MainWindow.h"
#include "TextInput.h"
#include "globals.h"
#include "stringres.h"

#include "kmysqladmin/frontend/deltabledlg.h"
#include "kmysqladmin/frontend/mtable/createtable.h"
#include "kmysqladmin/frontend/mtable/altertable.h"
#include "kmysqladmin/frontend/changetablename.h"
#include "kmysqladmin/sqlscript.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include "kmysqladmin/frontend/login/Login.h"
#include "kmysqladmin/frontend/browsetable/tableview.h"
#include "kmysqladmin/frontend/browsetable/serverview.h"
#include "kmysqladmin/frontend/status/StatusView.h"
#include "kmysqladmin/frontend/status/ThreadView.h"
#include "kmysqladmin/frontend/grantdialog/accessrights.h"
#include "kmysqladmin/frontend/profiles/connection_profiles.h"
#include "kmysqladmin/setup/settings_defines.h"
#include "kmysqladmin/backend/my_sql/my_sql.h"

using namespace std;

#define Inherited CMainWindowData

CMainWindow::CMainWindow( QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    TableView = 0;
    OldTableView = 0;
    StatusView = 0;
    ThreadView = 0;
    sql_server = 0;
    Grants = 0;
    sql_script = 0;
    m_Profiles = 0;
    msg_ptr = 0;
    m_CurrentCompact = GlobalSettings.getCompactLayout();
    m_CurrentOldbrowser=GlobalSettings.getOldBrowser();
    connect(&GlobalSettings,SIGNAL(settingsChanged()),this,SLOT(config_changed()));
}

CMainWindow::~CMainWindow()
{
    if (sql_server && sql_server->success_connect()) {
        GlobalSettings.SaveLastLogin(sql_server->User(),sql_server->Host(),
            sql_server->Port(),sql_server->Pass());
    }
}

void CMainWindow::connectSql()
{
    CLogin login;
    if (login.exec()) {
        _connect(login.get_user(),login.get_host(),
        login.get_port(),login.get_pass());
        KConfig * k = KGlobal::config();
        k->setGroup("last_login");
        k->writeEntry("user",login.get_user());
        k->writeEntry("host",login.get_host());
        k->writeEntry("port",login.get_port());
    }
}

bool CMainWindow::connected()
{
    return ( sql_server && sql_server->success_connect());
}

void CMainWindow::disconnectSql()
{
    if (!sql_server)
        return;
    if (sql_server->success_connect()) {
        GlobalSettings.SaveLastLogin(sql_server->User(),sql_server->Host(),
                                     sql_server->Port(),sql_server->Pass());
    }
    sql_server->sql_disconnect();
    OutputArea->append(i18n("Disconnected"));
    CloseAllDialogs();
    emit disconnected();
}

template<class T> void CMainWindow::initBrowser(T**target,const char*name)
{
    if (!sql_server || !sql_server->success_connect())
        return;
    if (!(*target)) {
        *target = new T(sql_server,0,name);
        if (m_CurrentCompact) {
            (*target)->setMinimumSize(0,0);
            m_MainStack->addWidget(*target);
        }
    }
    if (! (*target)->isVisible()) {
        if (!m_CurrentCompact) {
            (*target)->show();
        } else {
            m_MainStack->raiseWidget((*target));
            (*target)->standalone(false);
        }
    }
}

void CMainWindow::browseTables()
{
    if (m_CurrentOldbrowser) {
        initBrowser<CTableView>(&OldTableView,"TableView");
    } else {
        initBrowser<ServerView>(&TableView,"TableView");
    }
}

void CMainWindow::append_message(const std::string&text)
{
    if (text.size()==0)
        return;
    OutputArea->append(STL_TO_QT_STRING(text));
}

void CMainWindow::createTable()
{
    if (!sql_server)
        return;
    CCreateTable tablec(sql_server,0);
    tablec.exec();
}

void CMainWindow::alterTable()
{
    if (!sql_server)
        return;
    CAlterTable tablec(sql_server,0);
    tablec.exec();
}

void CMainWindow::createDB()
{
    bool ret;
    int i;
    QString s;
    CTextInput input;
    i = input.exec();
    if (!i)
        return;
    s = input.get_text();
    if (s.isEmpty())
        return;
    ret = sql_server->create_db(input.get_text());
}

void CMainWindow::dispStatus()
{
    initBrowser<CStatusView>(&StatusView,"StatusView");
}

void CMainWindow::view_threads()
{
    initBrowser<CThreadView>(&ThreadView,"ThreadView");
}

void CMainWindow::clearOutput()
{
    OutputArea->setText("");
}

void CMainWindow::accessControl()
{
    initBrowser<CAccessrights>(&Grants,"AccessControl");
}

void CMainWindow::reload_grants()
{
    if (sql_server)
        sql_server->refresh_grants();
}

void CMainWindow::flush_cache()
{
    if (sql_server)
        sql_server->refresh_cache();
}

void CMainWindow::close_tables()
{
    if (sql_server)
        sql_server->refresh_tables();
}

void CMainWindow::new_log()
{
    if (sql_server)
        sql_server->refresh_log();
}

void CMainWindow::shutdown()
{
    int i;
    i = KMessageBox::questionYesNo(this,CStringRes::get_string(56),
                                   CStringRes::get_string(130));
    if (i != KMessageBox::Yes)
        return;
    if (sql_server) {
        i = sql_server->shutdown();
        if (i < 0)
            return;
        disconnectSql();
    }
}

void CMainWindow::drop_table()
{
    int i = 0;
    CDeleteTableDlg drop_table_dlg(sql_server,0,"Delete Table");
    i = drop_table_dlg.exec();
}

void CMainWindow::drop_db()
{
}

void CMainWindow::set_msg_ptr(CSendMessage*ptr)
{
    msg_ptr = ptr;
    if (sql_server)
        sql_server->set_message_call_back(ptr);
}

void CMainWindow::rename_table()
{
    if (!sql_server || !sql_server->success_connect())
        return;
    CChangeTableName dlg(sql_server,0);
    dlg.exec();
}

void CMainWindow::sql_Edit()
{
    if (!sql_server)
        return;
    if (!sql_server->success_connect())
        return;
    if (!sql_script) {
        sql_script = new CSqlScript(sql_server,0,"SQL_Editor");
    }
    if (!sql_script->isVisible())
        sql_script->show();
}

bool CMainWindow::close()
{
    CloseAllDialogs();
    return CMainWindowData::close();
}

template<class T> void CMainWindow::removeWindow(T**ptr)
{
    if ((*ptr)) {
        if ((*ptr)->parentWidget()==m_MainStack) {
            m_MainStack->removeWidget((*ptr));
        }
        (*ptr)->close(true);
        (*ptr) = 0;
    }
}

void CMainWindow::CloseAllDialogs()
{
    if (m_CurrentCompact) {
        showLog();
    }
    removeWindow<ServerView>(&TableView);
    removeWindow<CTableView>(&OldTableView);
    removeWindow<CStatusView>(&StatusView);
    removeWindow<CThreadView>(&ThreadView);
    removeWindow<CAccessrights>(&Grants);
    removeWindow<CSqlScript>(&sql_script);
}

template<class T> void CMainWindow::reparentWindow(T**ptr)
{
    if ((*ptr)) {
        if (m_CurrentCompact&&(*ptr)->parentWidget()!=m_MainStack) {
            m_MainStack->addWidget((*ptr));
        } else if (!m_CurrentCompact&&(*ptr)->parentWidget()==m_MainStack) {
            (*ptr)->reparent(0,QPoint(10,10),true);
        }
        (*ptr)->standalone(!m_CurrentCompact);
    }
}

void CMainWindow::reparent_subwindows()
{
    bool c = GlobalSettings.getCompactLayout();
    if (c == m_CurrentCompact) return;
    m_CurrentCompact = c;
    reparentWindow<ServerView>(&TableView);
    reparentWindow<CTableView>(&OldTableView);
    reparentWindow<CStatusView>(&StatusView);
    reparentWindow<CThreadView>(&ThreadView);
    reparentWindow<CAccessrights>(&Grants);
    showLog();
}

void CMainWindow::RestoreLastConnect()
{
    string user,host,port,pass;
    GlobalSettings.RetrieveLastLogin(user,host,port,pass);
    _connect(user,host,port,pass);
}

void CMainWindow::ConnectQuick(const QString&which)
{
    if (which.length()==0) return;

    QMap<QString,QString> qvals = GlobalSettings.getConnectProfile(which);
    if (qvals.size()==0) return;

    _connect(QT_TO_STL_STRING(qvals[Settings_defines::_PROFILES_user]),
        QT_TO_STL_STRING(qvals[Settings_defines::_PROFILES_host]),
        QT_TO_STL_STRING(qvals[Settings_defines::_PROFILES_port]),
        QT_TO_STL_STRING(qvals[Settings_defines::_PROFILES_pass]));
}

void CMainWindow::_connect(const std::string&user,const std::string&host,
               const std::string&port,const std::string&pass)
{
    if (!sql_server)
        sql_server = new CMySql;
    if (!sql_server)
        return;
    sql_server->set_message_call_back(msg_ptr);

    removeWindow<ServerView>(&TableView);
    removeWindow<CTableView>(&OldTableView);
    removeWindow<CStatusView>(&StatusView);
    removeWindow<CThreadView>(&ThreadView);
    removeWindow<CAccessrights>(&Grants);
    removeWindow<CSqlScript>(&sql_script);

    sql_server->sql_connect(host,user,pass,port);
    if (sql_server->success_connect()) {
        GlobalSettings.SaveLastLogin(user,host,port,pass);
        string head=user;
        head+="@";
        if (host.size()==0) {
            head+= "localhost";
        } else {
            head+=host;
        }
        emit connected(head.c_str());
        append_message(sql_server->get_info());
    } else {
        QString msg = CStringRes::get_string(61);
        msg+="\n";
        msg+=CStringRes::get_string(62);
        QMessageBox::critical(this,
                    CStringRes::get_string(63),
                    msg);
        emit disconnected();
    }
}

void CMainWindow::showLog()
{
    m_MainStack->raiseWidget(OutputArea);
}

/*!
    \fn CMainWindow::connection_profiles
 */
void CMainWindow::connection_profiles()
{
    ConnectionProfiles dlg;
    dlg.exec();
    emit quickConsChanged();
}

void CMainWindow::config_changed()
{
    reparent_subwindows();
    bool c = GlobalSettings.getOldBrowser();
    if (c != m_CurrentOldbrowser) {
        showLog();
        removeWindow<ServerView>(&TableView);
        removeWindow<CTableView>(&OldTableView);
    }
    m_CurrentOldbrowser=c;
}
