// -*-Mode: C++;-*-
/**
 * This class is designed to create an dialog with variables
 * counts of text-input fields.
 *
 * @short Textinputdialog
 * @see QWidget
 * @see QDialog
 */
#ifndef CMultiTextInput_included
#define CMultiTextInput_included

#include <qstrlist.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qmultilineedit.h>
#include <qpixmap.h>
#include <qimage.h>

#include <vector>
#include <string>

#include "kmysqladmin/PatternPair.h"
#include "e_patternpair.h"
#include "MultiTextInputData.h"

class QFrame;
class EditEntry;

class CMultiTextInput : public CMultiTextInputData
{
    Q_OBJECT
public:
    CMultiTextInput(bool emptys_too=false,bool check_ops=false,QWidget* parent = NULL,const char* name = NULL);
    virtual ~CMultiTextInput();
    void build_widgets(e_PatternList*which,const char**operators=0,const char*checkboxmsg=0);
    PatternList*get_entries();

protected:
    std::vector<EditEntry> EditList;
    QGridLayout * EditLayout;
    QFrame*FrameWidget;
    bool m_BlobAsImage;
    bool m_ScaleBlob;
    int m_blob_width,m_blob_height;
    QPixmap blobImage(const QImage&aImage);
    void handleBlobSettings();
    bool readFile(const std::string&aFile,std::string&target);
    bool build_result();

    int min_x;
    int min_y;
    bool emptys_too,check_ops;
    PatternList*m_result_list;

protected slots:
    virtual void keyPressEvent(QKeyEvent*e);
    virtual void change_focus();
    virtual void checkInput();
};
#endif // CMultiTextInput_included
