#include "textstorage.h"
#include <kfiledialog.h>
#include <ktextedit.h>
#include <qlineedit.h>
#include <qfile.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kio/netaccess.h>
#include <klocale.h>

CTextstorage::CTextstorage( QWidget* parent, const char* name, WFlags fl )
    : CTextstorageData(parent,name,fl)
{
    fName = "";
    m_TextEdit->setTextFormat(Qt::PlainText);
}

CTextstorage::~CTextstorage()
{
}

void CTextstorage::setText(const QString&s)
{
    m_TextEdit->setText(s);
}

void CTextstorage::readInput()
{
    KURL url =  KFileDialog::getOpenURL();
    QString f = url.url();
    if (f.length()==0) {
        m_filenameEdit->setText("");
    } else {
        m_filenameEdit->setText(f);
    }
}

const QString & CTextstorage::getname()const
{
    return fName;
}

const QString CTextstorage::getText()const
{
    return m_TextEdit->text();
}

void CTextstorage::fnameChanged(const QString&f)
{
    fName = f;
}

void CTextstorage::readContent()
{
    KURL url(fName);
    QString filename;

    if( !KIO::NetAccess::download( url, filename,this ) ) {
        KMessageBox::error(this,i18n(
        "Error while trying to open file:\n %1").arg(url.url()));
        KIO::NetAccess::removeTempFile( filename );
        return;
    }
    QFile file(filename);
    if ( file.open( IO_ReadOnly ) ) {
        QTextStream stream( &file );
        m_TextEdit->setText( stream.read() );
    }
    KIO::NetAccess::removeTempFile( filename );
}
