#include <kapp.h>
#include <qkeycode.h>
#include "kmysqladmin/stringres.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/setup/settings_defines.h"

#include "Login.h"
#include <kglobal.h>
#include <kconfig.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>

#define Inherited LoginData

CLogin::CLogin(QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    setCaption( CStringRes::get_string(45));
    setIcon(kapp->icon());
    KConfig * k = KGlobal::config();
    k->setGroup("last_login");
    QString user,host,port;
    user = k->readEntry("user");
    host = k->readEntry("host");
    port = k->readEntry("port");
    PassEdit->setText("");
    HostEdit->setText("");
    UserEdit->setText("");

    if (port.length() > 0)
        PortEdit->setText(port);
    else
        PortEdit->setText("3306");
    if (host.length() > 0)
        HostEdit->setText(host);
    if (user.length() > 0)
        UserEdit->setText(user);
    HostEdit->setFocus();
    initProfileList();
}

CLogin::~CLogin()
{
}

void CLogin::initProfileList()
{
    m_ProfilesList->clear();
    QStringList profiles = GlobalSettings.getConnectProfilesList();
    m_ProfilesList->insertItem("");
    m_ProfilesList->insertStringList(profiles);
    if (profiles.count()==0) {
        m_ProfilesList->setEnabled(false);
    } else {
        m_ProfilesList->setEnabled(true);
    }
}

void CLogin::profileHilighted(const QString&s)
{
    if (s.length()==0) return;
    QMap<QString,QString> vals = GlobalSettings.getConnectProfile(s);
    
    UserEdit->setText(vals[Settings_defines::_PROFILES_user]);
    HostEdit->setText(vals[Settings_defines::_PROFILES_host]);

    if (vals[Settings_defines::_PROFILES_pass].length()==0) {
        PassEdit->setText("");
    } else {
        PassEdit->setText(vals[Settings_defines::_PROFILES_pass]);
    }
    PortEdit->setText(vals[Settings_defines::_PROFILES_port]);
}

void CLogin::focus_user()
{
    UserEdit->setFocus();
}
void CLogin::focus_password()
{
    PassEdit->setFocus();
}
void CLogin::focus_port()
{
    PortEdit->setFocus();
}
void CLogin::focus_ok()
{
    OkButton->setFocus();
}

void CLogin::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
        e->accept();
        OkButton->animateClick();
        return;
    }
    if (e->key()==Key_Escape) {
        e->accept();
        reject();
        return;
    }
    if (e->isAccepted())
        return;
    Inherited::keyPressEvent(e);
}
