//-*-Mode: C++;-*-
/***************************************************************************
 *  stringlist.h  -  description
 *  ----------------------------
 *  begin                : Fri Jul 30 1999
 *  copyright            : (C) 1999 by Rajko Albrecht
 *  email                : Rajko.Albrecht@informatik.tu-chemnitz.de 
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// $Id: stringlist.h 48 2003-10-01 01:07:04Z ral $


#ifndef STRINGLIST_H
#define STRINGLIST_H

#include "stringhelper.h"
#include <vector>
#include <string>

/*!
 * Implementation of a string-list
 * with search functions
 * \author Rajko Albrecht
 */

// there is a problem with the operators += = etc. in the string classes of stl
// if the new string is NULL, it get a segfault, cause the straits.h did not 
// recover a NULL - pointer as a empty string :(((((

//! a simple definition for avoiding problems with some compiler
typedef std::vector<std::string> base_stringlist;

//! a string list with search function
/*!
 * Implements a string list based on std-vector with integrated case-sensitiv search function
 */
class stringlist:public base_stringlist
{
public:
protected:
    //! the search position
    /*!
     * holds the value of the last result
     */
    iterator _search_pos;
public:
    //! search function
    /*!
     * \param what the string to search for
     * \param start_pos the position of list to start for search
     * \return the position if found else vector::end()
     */
    iterator find(const std::string&what,iterator start_pos = iterator(0));
    iterator find_nocase(const std::string&what,iterator start_pos = iterator(0));
};

inline std::vector<std::string>::iterator
stringlist::find(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos!=iterator(0)?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
        if (_search_pos->compare(what) == 0) {
            return _search_pos;
        }
    }
    return end();
}

inline std::vector<std::string>::iterator
stringlist::find_nocase(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos!=iterator(0)?start_pos:begin();
    return std::find_if(_search_pos,end(),Caseequif(what));
}


//! stringlist with no-casesensitive search
class stringIlist : public stringlist {
public:
    //! the search routine itself
    /*!
     * \param what the string to search for
     * \param start_pos the position to start - default the first item of list
     * \return the position if found else vector::end()
     */
    iterator find(const std::string&what,iterator start_pos = iterator(0));
};

inline std::vector<std::string>::iterator
stringIlist::find(const std::string&what,iterator start_pos)
{
    return find_nocase(what,start_pos);
}

//! a simple list of stringlists
typedef std::vector<stringlist> list_vector;

#endif
