/***************************************************************************
                          settings.cpp  -  description
                             -------------------
    begin                : Sat May 20 2000
    copyright            : (C) 2000 by Rajko Albrecht
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "settings.h"
#include "settings_defines.h"
#include <pwd.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string>
#include <errno.h>
#include <stdio.h>
#include "kmysqladmin/helpers/helpers.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include <qfont.h>
#include <qcolor.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kwallet.h>
#include <qmap.h>

#define _GLOBAL_SECTION "GLOBALS"
#define _USER "last_user"
#define _HOST "last_host"
#define _PORT "last_port"
#define _PASS "last_password"
#define _LAST_LOGIN_MAP "last_login"

#define _BLOB_SECTION "BLOBS"
#define _DISP_BLOBS "display_blob_as_image"
#define _SCALE_BLOBS "scale_blob_as_image"
#define _MAX_BLOB_WIDTH "max_blob_image_width"
#define _MAX_BLOB_HEIGHT "max_blob_image_height"

#define _DISP_REAL_MULTILINES "display_real_multilines"
#define _DISP_COMPACT "display_compact_layout"
#define _DISP_OLD_BROWSER "display_old_tablebrowser"

#define _FONT_SECTION "displayfonts"
#define _FIX_FONT "fixed_font"
#define _NPROP_FONT "non_prop_font"

#define _THREAD_POLLTIME "thread_polltime"
#define _STATUS_POLLTIME "status_polltime"

#define _SCRIPTEDITOR_SECTION "script_editor"
#define _SCRIPTRES_FORMATTED "script_result_formatted"
#define _SCRIPT_HIGHLIGHTED "script_syntax_highlight"

#define _WALLET_NAME "kmysqladmin"
#define _PROFILES_list "connection_profiles"

CSettings GlobalSettings;

using namespace std;

void CSettings::set_fixed_font(const QFont&fnt)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    k->writeEntry(_FIX_FONT,fnt);
    make_f_font_signal();
}

QFont CSettings::get_fixed_font()
{
    QFont fnt("fixed");
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    return k->readFontEntry(_FIX_FONT,&fnt);
}

void CSettings::set_nprop_font(const QFont&fnt)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    k->writeEntry(_NPROP_FONT,fnt);
    make_np_font_signal();
}

QFont CSettings::get_nonprop_font()
{
    QFont fnt("Sans");
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    return k->readFontEntry(_NPROP_FONT,&fnt);
}

bool CSettings::init_files()
{
#if 0
    uid_t user_id;
    struct passwd*zgr;
    std::string init_file;
    int ret;
    FILE*init_f;

    user_id = geteuid();
    zgr = getpwuid(user_id);
    init_file = zgr->pw_dir;
    init_file+="/.kmysqladmin";
    int mode = 127;

    ret = mkdir(init_file.c_str(),S_IRUSR|S_IWUSR|S_IXUSR );
    if (ret == -1) {
        if (errno == EEXIST) {
            ret = 0;
        } else {
            perror("Error creating DIR");
        }
    }

    if (ret == -1) {
        return false;
    }
    ret = chmod(init_file.c_str(),S_IRUSR|S_IWUSR|S_IXUSR);
    std::string settings_file = init_file;

    init_file+="/last_session";
    settings_file+="/Settings";
#endif
    return true;
}

CSettings::CSettings()
{
    init_files();
}

CSettings::~CSettings()
{
}

KWallet::Wallet*CSettings::openWallet(const std::string&aDir)
{
    KWallet::Wallet * myWall = KWallet::Wallet::openWallet("kdewallet");
    if (!myWall || aDir.length()==0) return myWall;
    if (!myWall->hasFolder(aDir.c_str())) {
        if ( !myWall->createFolder(aDir.c_str()) ) {
            delete myWall; return 0;
        }
    }
    myWall->setFolder(aDir.c_str());
    return myWall;
}

void CSettings::SaveLastLogin(const std::string user,const std::string host,
                   const std::string port,const std::string pass)
{
    KWallet::Wallet * myWall = openWallet(_WALLET_NAME);
    if (!myWall) {
        return;
    }
    QMap<QString,QString> login_values;
    login_values[_USER]=user.c_str();
    login_values[_HOST]=host.c_str();
    login_values[_PORT]=port.c_str();
    login_values[_PASS]=pass.c_str();
    myWall->writeMap(_LAST_LOGIN_MAP,login_values);
    delete myWall;
}

bool CSettings::RetrieveLastLogin(std::string&user,std::string&host,
                                  std::string&port,std::string&pass)
{
    KWallet::Wallet * myWall = openWallet(_WALLET_NAME);
    if (!myWall) {
        return false;
    }
    QMap<QString,QString> login_values;
    myWall->readMap(_LAST_LOGIN_MAP,login_values);
    if (login_values.find(_USER)!=login_values.end()) {
        user = login_values[_USER].latin1();
    }
    if (login_values.find(_HOST)!=login_values.end()) {
        host = login_values[_HOST].latin1();
    }
    if (login_values.find(_PORT)!=login_values.end()) {
        port = login_values[_PORT].latin1();
    }
    if (login_values.find(_PASS)!=login_values.end()) {
        pass = login_values[_PASS].latin1();
    }
    delete myWall;
    return true;
}

void CSettings::ThreadPolltime(int aTimeout)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_THREAD_POLLTIME,aTimeout);
    make_thread_signal(aTimeout);
}

int CSettings::ThreadPolltime()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readNumEntry(_THREAD_POLLTIME,60);
}

void CSettings::StatusPolltime(int aTimeout)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_STATUS_POLLTIME,aTimeout);
    make_status_signal(aTimeout);
}

int CSettings::StatusPolltime()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readNumEntry(_STATUS_POLLTIME,60);
}

bool CSettings::ScriptOutputAsRich()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry(_SCRIPTRES_FORMATTED,false);
}

void CSettings::ScriptOutputAsRich(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry(_SCRIPTRES_FORMATTED,how);
}

bool CSettings::SyntaxHighlight()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry(_SCRIPT_HIGHLIGHTED,true);
}

void CSettings::SyntaxHighlight(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry(_SCRIPT_HIGHLIGHTED,how);
}

QColor CSettings::getScriptColor(const std::string&which,const QColor&aDefaultColor)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readColorEntry((which+"_color").c_str(),&aDefaultColor);
}

void CSettings::setScriptColor(const std::string&which,const QColor&aColor)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry((which+"_color").c_str(),aColor);
}

bool CSettings::getScriptbold(const std::string&which,bool def)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry((which+"_bold").c_str(),def);
}

void CSettings::setScriptbold(const std::string&which,bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry((which+"_bold").c_str(),how);
}

bool CSettings::getScriptit(const std::string&which,bool def)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry((which+"_italic").c_str(),def);
}

void CSettings::setScriptit(const std::string&which,bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry((which+"_italic").c_str(),how);
}


/*!
    \fn CSettings::getConnectProfile(const std::string&aProfile)
 */
QMap<QString,QString> CSettings::getConnectProfile(const QString&aProfile)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    QMap<QString,QString> result;
    if (aProfile.length()==0) return result;
    result = k->entryMap(Settings_defines::_PROFILES_prefix+aProfile);
    result[Settings_defines::_PROFILES_pass]="";
    KWallet::Wallet * myWall = openWallet(_WALLET_NAME);
    if (!myWall) {
        return result;
    }
    QString pass("");
    if (!myWall->readPassword(Settings_defines::_PROFILES_prefix+aProfile,pass)) {
        result[Settings_defines::_PROFILES_pass]=pass;
    }
    delete myWall;
    return result;
}

QStringList CSettings::getConnectProfilesList()
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readListEntry(_PROFILES_list);
}

void CSettings::addConnectProfile(const QString&aName,const QString&aHost,const QString&aUser,const QString&aPort,const QString&aPass)
{
    KConfig * k = KGlobal::config();
    QString name = aName;
    if (name.length()==0) return;
    name.replace(',','_');
    QStringList currents = getConnectProfilesList();
    if (currents.find(name)==currents.end()) {
        currents+=name;
        k->setGroup(_GLOBAL_SECTION);
        k->writeEntry(_PROFILES_list,currents);
    }
    k->setGroup(Settings_defines::_PROFILES_prefix+name);
    k->writeEntry(Settings_defines::_PROFILES_user,aUser);
    k->writeEntry(Settings_defines::_PROFILES_host,aHost);
    k->writeEntry(Settings_defines::_PROFILES_port,aPort);
    if (aPass.length()>0) {
        KWallet::Wallet * myWall = openWallet(_WALLET_NAME);
        if (!myWall) {
            return;
        }
        myWall->writePassword(Settings_defines::_PROFILES_prefix+name,aPass);
        delete myWall;
    }
}

void CSettings::addConnectProfile(const QMap<QString,QString>&aConnect)
{
    addConnectProfile(aConnect[Settings_defines::_PROFILES_name],
            aConnect[Settings_defines::_PROFILES_host],
            aConnect[Settings_defines::_PROFILES_user],
            aConnect[Settings_defines::_PROFILES_port],
            aConnect[Settings_defines::_PROFILES_pass]);
}

void CSettings::deleteConnectProfile(const QString&aName)
{
    if (aName.length()==0) return;
    KConfig * k = KGlobal::config();
    QStringList currents = getConnectProfilesList();
    QStringList::iterator it;
    if ( (it = currents.find(aName))!=currents.end()) {
        currents.erase(it);
        k->setGroup(_GLOBAL_SECTION);
        k->writeEntry(_PROFILES_list,currents);
    }
    k->deleteGroup(Settings_defines::_PROFILES_prefix+aName);
    KWallet::Wallet * myWall = openWallet(_WALLET_NAME);
    if (!myWall) {
        return;
    }
    myWall->removeEntry(Settings_defines::_PROFILES_prefix+aName);
    delete myWall;
}

void CSettings::getBlobimages(bool&aDisplayimages, bool&aScaleimages, int&aMaxwidth, int&aMaxheight)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_BLOB_SECTION);
    aDisplayimages = k->readBoolEntry(_DISP_BLOBS,true);
    aScaleimages = k->readBoolEntry(_SCALE_BLOBS,true);
    aMaxwidth = k->readNumEntry(_MAX_BLOB_WIDTH,30);
    aMaxheight = k->readNumEntry(_MAX_BLOB_HEIGHT,30);
}

void CSettings::setBlobimages(bool aDisplayimages, bool aScaleimages, int aMaxwidth, int aMaxheight)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_BLOB_SECTION);
    k->writeEntry(_DISP_BLOBS,aDisplayimages);
    k->writeEntry(_SCALE_BLOBS,aScaleimages);
    k->writeEntry(_MAX_BLOB_WIDTH,aMaxwidth);
    k->writeEntry(_MAX_BLOB_HEIGHT,aMaxheight);
}

void CSettings::setRealmultiLines(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_DISP_REAL_MULTILINES,how);
}

bool CSettings::getRealmultilines()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readBoolEntry(_DISP_REAL_MULTILINES,true);
}

void CSettings::setCompactLayout(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_DISP_COMPACT,how);
}

bool CSettings::getCompactLayout()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readBoolEntry(_DISP_COMPACT,true);
}

void CSettings::setOldBrowser(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_DISP_OLD_BROWSER,how);
}

bool CSettings::getOldBrowser()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readBoolEntry(_DISP_OLD_BROWSER,false);
}
