#include "setupscriptcolor.h"
#include "kmysqladmin/frontend/scripteditor/sqlsyntax.h"
#include "kmysqladmin/setup/settings.h"
#include <qtextedit.h>
#include <kcolorbutton.h>
#include <qfont.h>
#include <qcheckbox.h>

SetupScriptcolor::SetupScriptcolor(QWidget *parent, const char *name)
    :SetupScriptcolorData(parent,name)
{
#ifndef NO_SQL_HIGHLIGHT
    init_done = false;
    QColor d;
    TestSyntax = new sqlsyntax(sampleTextEdit);
    QFont f;
    f = GlobalSettings.get_fixed_font();
    TestSyntax->setDefaultFont(f);
    d = GlobalSettings.getScriptColor(sqlsyntax::STATEMENT,QColor(255,0,0));
    TestSyntax->setStatementColor(d);
    statementColorButton->setColor(d);
    d = GlobalSettings.getScriptColor(sqlsyntax::KEYWORD,QColor(0,200,0));
    TestSyntax->setKeyColor(d);
    keyWordsColorButton->setColor(d);
    d = GlobalSettings.getScriptColor(sqlsyntax::COMMENT,QColor(120,120,120));
    TestSyntax->setCommentColor(d);
    commentsColorButton->setColor(d);
    d = GlobalSettings.getScriptColor(sqlsyntax::DATATYPE,QColor(0,0,200));
    TestSyntax->setDatatypesColor(d);
    dataColorButton->setColor(d);
    d = GlobalSettings.getScriptColor(sqlsyntax::STRING,QColor(0,0,255));
    TestSyntax->setStringColor(d);
    stringColorButton->setColor(d);
    
    bool bold;
    bold = GlobalSettings.getScriptbold(sqlsyntax::STATEMENT,true);
    TestSyntax->statementBold(bold);
    statementBold->setChecked(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::KEYWORD,false);
    keyBold->setChecked(bold);
    TestSyntax->keywordBold(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::COMMENT,false);
    TestSyntax->commentBold(bold);
    commentBold->setChecked(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::DATATYPE,false);
    TestSyntax->datatypeBold(bold);
    dataBold->setChecked(bold);
    bold = GlobalSettings.getScriptbold(sqlsyntax::STRING,false);
    TestSyntax->stringBold(bold);
    stringsBold->setChecked(bold);
    
    bold = GlobalSettings.getScriptit(sqlsyntax::STATEMENT,false);
    TestSyntax->statementItalic(bold);
    statementItalic->setChecked(bold);
    bold = GlobalSettings.getScriptit(sqlsyntax::KEYWORD,false);
    TestSyntax->keywordItalic(bold);
    keywordItalic->setChecked(bold);
    bold = GlobalSettings.getScriptit(sqlsyntax::COMMENT,false);
    TestSyntax->commentItalic(bold);
    commentsItalic->setChecked(bold);
    bold = GlobalSettings.getScriptit(sqlsyntax::DATATYPE,false);
    TestSyntax->datatypeItalic(bold);
    dataItalic->setChecked(bold);
    bold = GlobalSettings.getScriptit(sqlsyntax::STRING,false);
    TestSyntax->stringItalic(bold);
    stringItalic->setChecked(bold);
#endif
    init_done = true;
}

void SetupScriptcolor::accept()
{
#ifndef NO_SQL_HIGHLIGHT
    GlobalSettings.setScriptbold(sqlsyntax::STATEMENT,statementBold->isChecked());
    GlobalSettings.setScriptbold(sqlsyntax::KEYWORD,keyBold->isChecked());
    GlobalSettings.setScriptbold(sqlsyntax::COMMENT,commentBold->isChecked());
    GlobalSettings.setScriptbold(sqlsyntax::DATATYPE,dataBold->isChecked());
    GlobalSettings.setScriptbold(sqlsyntax::STRING,stringsBold->isChecked());

    GlobalSettings.setScriptit(sqlsyntax::STATEMENT,statementItalic->isChecked());
    GlobalSettings.setScriptit(sqlsyntax::KEYWORD,keywordItalic->isChecked());
    GlobalSettings.setScriptit(sqlsyntax::COMMENT,commentsItalic->isChecked());
    GlobalSettings.setScriptit(sqlsyntax::DATATYPE,dataItalic->isChecked());
    GlobalSettings.setScriptit(sqlsyntax::STRING,stringItalic->isChecked());

    GlobalSettings.setScriptColor(sqlsyntax::STATEMENT,statementColorButton->color());
    GlobalSettings.setScriptColor(sqlsyntax::KEYWORD,keyWordsColorButton->color());
    GlobalSettings.setScriptColor(sqlsyntax::COMMENT,commentsColorButton->color());
    GlobalSettings.setScriptColor(sqlsyntax::DATATYPE,dataColorButton->color());
    GlobalSettings.setScriptColor(sqlsyntax::STRING,stringColorButton->color());
#endif
    SetupScriptcolorData::accept();
}

SetupScriptcolor::~SetupScriptcolor()
{
    if (TestSyntax) delete TestSyntax;
}

void SetupScriptcolor::statementColorChanged(const QColor&aColor)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->setStatementColor(aColor);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::keyColorChanged(const QColor&aColor)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->setKeyColor(aColor);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::dataColorChanged(const QColor&aColor)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->setDatatypesColor(aColor);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::stringsColorChanged(const QColor&aColor)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->setStringColor(aColor);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::commentColorChanged(const QColor&aColor)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->setCommentColor(aColor);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::commentBoldtoggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->commentBold(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::statementBoldtoggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->statementBold(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::keyBoldtoggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->keywordBold(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::stringBoldtoggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->stringBold(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::dataBoldtoggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->datatypeBold(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::statementItToggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->statementItalic(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::keyItToggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->keywordItalic(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::dataItToggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->datatypeItalic(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::stringItToggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->stringItalic(how);
    TestSyntax->rehighlight();
#endif
}

void SetupScriptcolor::commentItToggled(bool how)
{
#ifndef NO_SQL_HIGHLIGHT
    if (!init_done) return;
    TestSyntax->commentItalic(how);
    TestSyntax->rehighlight();
#endif
}
