// -*-Mode: C++;-*-

#ifndef CSqlScript_included
#define CSqlScript_included

#include <kmenubar.h>
#include <kurl.h>
#include <kaction.h>
#include "kmysqladmin/frontend/scripteditor/sqlscriptdata.h"
#include <string>
#include "kmysqladmin/helpers/stringlist.h"
#include "kmysqladmin/sendmessage.h"
#include "kstatusbar.h"
#include <qtimer.h>
#include "kmysqladmin/helpers/smart_pointer.h"
#include "kmysqladmin/frontend/scripteditor/edit.h"

class CMySql;
class KPopupMenu;
class sqlsyntax;

class CSqlScript : public CSqlScriptData, virtual public CSendMessage
{
    Q_OBJECT
public:
    CSqlScript(smart_pointer<CMySql>& _sql_server,QWidget* parent = NULL,const char* name = NULL );
    virtual ~CSqlScript();
    virtual void append_message(const std::string&message);

protected slots:
    virtual void close_You();
    virtual void TabSelected(int);
    virtual void submit();
    virtual void save_script();
    virtual void save_script_as();
    virtual void load_script();
    virtual void new_script();
    virtual void statusTimeout();
    virtual void saveResult();
    virtual void searchText();
    virtual void searchAgain();
    void keyPressEvent ( QKeyEvent * e );
    void set_cursor_info();
    void FixFontChanged();
    virtual void toggle_show_rich();
    virtual void toggle_use_highlight();
    virtual void setup_colors();
    virtual void setupSyntaxObject();
    virtual void slotOpen(const KURL&);
    virtual void hide();

public slots:
    virtual bool close(bool );

protected:
    std::string ResultText;
    std::string ScriptText;
    std::string ErrorText;
    std::string search_text;
    std::string m_FileName;
    
    smart_pointer<CMySql> sql_server;
    bool modified;
    int last_tab;
    KMenuBar*MenuBar;
    KPopupMenu*settings_menu;
    bool rich_text_set,use_highlight;
    QTimer*status_Timer;
    sqlsyntax * SQLSyntax;
    
    /*
     * for menues and so on
     */
    KRecentFilesAction * m_recentFiles;
    KActionCollection * mActionCollection;
    KToggleAction *switchRichtext;
#ifndef NO_SQL_HIGHLIGHT
    KToggleAction*switchHighlight;
#endif
    
    void search_forward();
    void split_commands(stringlist & target);
    virtual bool load_script(const QString&aFile);
    virtual void save_state();
    virtual std::string displayRichResult(const std::string&command, const list_vector&target, const stringlist&headers);
    virtual CEdit * currentWindow();
    void save_string(const std::string&contents,int format);
    void setStatusText(const char*text,unsigned int timeout=0);
    KActionCollection *actionCollection() { return mActionCollection; };
};
#endif // CSqlScript_included
