/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #ifndef _FILEOPENER_H_
#define _FILEOPENER_H_

#define DEVNULL "/dev/null"


// workaround for bug in glibc on RedHat 5.0 and Debian 2.1
#if defined(__GLIBC__) && (__GLIBC__ == 2 && __GLIBC_MINOR__ == 0 && defined(__linux__))
# define MY_SCM_RIGHTS 1
#else
# define MY_SCM_RIGHTS SCM_RIGHTS
#endif

// ### add by bhughes - FreeBSD defines 'BSD' in sys/param.h
#include <sys/param.h>

#if defined(BSD) || defined(__svr4__)
# define IOV_BASE_CAST (char *)
#else
# define IOV_BASE_CAST (void *)
#endif

#include "knetconfig.h"
const char *pppdPath();

class Opener {

public:
  Opener(int);
  ~Opener();

  enum { OpenDevice = 1,
         OpenLock, RemoveLock,
         OpenResolv,
         OpenSysLog,
         SetSecret, RemoveSecret,
         SetHostname,
         ExecPPPDaemon, KillPPPDaemon,
	 PPPDExitStatus,
         Stop,
	 KillRoguePPPD,
	 GetPerm };
  enum Auth { PAP = 1, CHAP };
  enum { MaxPathLen = 30, MaxStrLen = 40, MaxArgs = 100 };

private:
  enum { Original=0x100, New=0x200, Old=0x400 } Version;
  void mainLoop();
  int sendFD(int ttyfd, struct ResponseHeader *response);
  int sendResponse(struct ResponseHeader *response);
  const char *deviceByIndex(int idx);
  bool createAuthFile(Auth method, char *username, char *password);
  bool removeAuthFile(Auth method);
  const char* authFile(Auth method, int version = Original);
  bool execpppd(const char *arguments);
  bool killpppd()const;
  bool killRoguePppd();
  bool getperm(const char *password);
  void parseargs(char* buf, char** args);

  int socket;
  int ttyfd;
  char lockfile[MaxPathLen+1];
};


struct RequestHeader {
  int	type;
  int	len;
  //  int   id;     // TODO: Use a transmission id and check whether
                    //       response matches request
};

struct ResponseHeader {
  int	status; /* 0 or errno */
  //  int   id;
};

struct OpenModemRequest {
  struct RequestHeader header;
  int    deviceNum;
};

struct RemoveLockRequest {
  struct RequestHeader header;
};

struct OpenLockRequest {
  struct RequestHeader header;
  int    deviceNum;
  int    flags;
};

struct OpenResolvRequest {
  struct RequestHeader header;
  int    flags;
};

struct OpenLogRequest {
  struct RequestHeader header;
};

struct SetSecretRequest {
  struct RequestHeader header;
  Opener::Auth method;   // PAP or CHAP
  char   username[Opener::MaxStrLen+1];
  char   password[Opener::MaxStrLen+1];
};

struct RemoveSecretRequest {
  struct RequestHeader header;
  Opener::Auth method;   // PAP or CHAP
};

struct SetHostnameRequest {
  struct RequestHeader header;
  char   name[Opener::MaxStrLen+1];
};

struct ExecDaemonRequest {
  struct RequestHeader header;
  char   arguments[MAX_CMDLEN+1];
};

struct KillDaemonRequest {
  struct RequestHeader header;
};

struct PPPDExitStatusRequest {
  struct RequestHeader header;
};

struct StopRequest {
  struct RequestHeader header;
};

struct PermissionRequest {
  struct RequestHeader header;
  char password[MAX_CMDLEN+1];
};

union AllRequests {
  struct RequestHeader header;
  struct OpenModemRequest  modem;
  struct OpenLockRequest lock;
  struct RemoveLockRequest unlock;
  struct OpenResolvRequest resolv;
  struct SetSecretRequest secret;
  struct RemoveSecretRequest remove;
  struct SetHostnameRequest host;
  struct OpenLogRequest log;
  struct ExecDaemonRequest daemon;
  struct ExecDaemonRequest kill;
  struct PPPDExitStatusRequest status;
  struct StopRequest stop;
  struct PermissionRequest permission;
};

#endif
