/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <asm/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <arpa/inet.h>

#include <linux/netdevice.h>
#include <linux/rtnetlink.h>
#include <linux/wireless.h>


#ifndef KNETDOCKAPP_GLOBAL
#define KNETDOCKAPP_GLOBAL 

#include <qstring.h>

typedef struct IfStat
{
	unsigned long long int bytes;
	unsigned long long int bytes_in;
	unsigned long long int bytes_out;
	unsigned long long int speed;
	unsigned long long int speed_in;
	unsigned long long int speed_out;
};

typedef struct AddrStat
{
	QString ip;
	QString mask;
	QString mac;
};

typedef struct WiFiStat
{
	short signal_level;
	short noise_level;
	short link_qual;
	QString essid;
};

typedef struct KNetDockIf
{
	IfStat *total;
	IfStat *oldstat;
	WiFiStat *wstat;
	AddrStat *addrstat;
	bool wr;
};



#endif
