// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.5 $

//***********************************************
//***  hk_kdeqbe PART definition             ***
//***********************************************
#include "hk_kdeqbepart.h"
#include "hk_kdeqbepartfactory.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <kactionclasses.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qcombobox.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
class hk_kdeqbepartprivate
{
  public:
  hk_kdeqbepartprivate()
  	{
		p_qbe=NULL;
	}
   hk_kdeqbe* p_qbe;
   KAction* p_addaction;
   KToggleAction* p_distinctaction;
   KWidgetAction* p_qbetypeselectaction; 
   QComboBox* p_qbetypeselect;
};

hk_kdeqbepart::hk_kdeqbepart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdeqbepartprivate;
    setInstance(hk_kdeqbepartfactory::instance());
    p_private->p_qbe = new hk_kdeqbe(pWidget);
//    p_private->p_qbe->p_part=this;
    setWidget(p_private->p_qbe);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
     setXMLFile(locate("data","hk_kdeclasses/hk_kdeqbepart.rc"));

    p_private->p_addaction = new KAction(i18n("&Add datasource"),loader->loadIcon("gridadd22x22",KIcon::User),0,this,SLOT(add_action()),actionCollection(),"add");
    p_private->p_distinctaction = new KToggleAction(i18n("&Distinct rows"),
    /*loader->loadIcon("gridadd22x22",KIcon::User)*/
    0,0,p_private->p_qbe,SLOT(distinct_changed()),actionCollection(),"distinct");
    p_private->p_qbetypeselect= new QComboBox(0L,"p_qbetypeselect");
    p_private->p_qbetypeselect->insertItem(i18n("Select query"));
    p_private->p_qbetypeselect->insertItem(i18n("Groupselect query"));
    p_private->p_qbetypeselect->insertItem(i18n("Update query"));
    p_private->p_qbetypeselect->insertItem(i18n("Delete query"));
    p_private->p_qbetypeselectaction=new KWidgetAction(p_private->p_qbetypeselect,i18n("&Add datasource"),0,0,0,actionCollection(),"qbetypeselect");
    connect(p_private->p_qbetypeselect,SIGNAL(activated(int)),this,SLOT(qbetypeselect_action(int)));
    connect(p_private->p_qbe,SIGNAL(signal_qbetype_has_changed()),this,SLOT(qbetypechange_action()));
    connect(p_private->p_qbe,SIGNAL(signal_distinct_has_changed()),this,SLOT(distinct_action()));
}

hk_kdeqbepart::~hk_kdeqbepart()
{
  delete p_private->p_addaction;
  delete p_private->p_qbetypeselectaction;
  delete p_private->p_qbetypeselect;
  delete p_private->p_distinctaction;
  delete p_private;
}



/*void hk_kdeqbepart::show_dbdesignercolumndialog(void)
{
    p_private->p_qbe->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdeqbepart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdeqbepart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdeqbepart::saveFile()
{
    return true;
}

hk_kdeqbe* hk_kdeqbepart::dbdesigner(void)
{
 return p_private->p_qbe;
}

void hk_kdeqbepart::add_action(void)
{
p_private->p_qbe->add_datasource();
}


void hk_kdeqbepart::qbetypeselect_action(int t)
{
cerr <<"hk_kdeqbepart::qbetypeselect_action"<<endl;
 hk_qbe::enum_querytype ntype=hk_qbe::qt_select;
 switch (t)
 {
    case 1 : ntype=hk_qbe::qt_groupselect;break;
    case 2 : ntype=hk_qbe::qt_update;break;
    case 3 : ntype=hk_qbe::qt_delete;break;
    default: ntype=hk_qbe::qt_select;
 }
p_private->p_qbe->set_querytype(ntype);

}


void hk_kdeqbepart::qbetypechange_action(void)
{
p_private->p_qbetypeselect->blockSignals(true);
int nr=0;
switch(p_private->p_qbe->querytype())
{
  case hk_qbe::qt_groupselect : nr=1;break;
  case hk_qbe::qt_update : nr=2;break;
  case hk_qbe::qt_delete : nr=3;break;
  default	      :	nr=0;
}
p_private->p_qbetypeselect->setCurrentItem(nr);
p_private->p_qbetypeselect->blockSignals(false);
}

KAboutData* hk_kdeqbepart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdeqbepart", I18N_NOOP("hk_kdeqbepart"),
        "0.1", I18N_NOOP("Query by Example editor"),
        KAboutData::License_GPL,"(c) 2002-2004, Horst Knorr <hk_classes@knoda.org>");

    return a;

}



void hk_kdeqbepart::distinct_action(void)
{
  p_private->p_distinctaction->setChecked(p_private->p_qbe->distinct());

}



