/***************************************************************************
                          knutvardata.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTVARDATA_H
#define KNUTVARDATA_H


/*******************************/
/*    GLOBAL DEFINE            */
/*******************************/

#define DEFAULT_BG_COLOR Qt::lightGray
#define DEFAULT_FINGER_COLOR Qt::black
#define DEFAULT_OK_COLOR Qt::green
#define DEFAULT_WARNNING_COLOR Qt::yellow
#define DEFAULT_ERROR_COLOR Qt::red
#define DEFAULT_SCALE_COLOR Qt::black
#define DEFAULT_FONT_COLOR Qt::black
#define DEFAULT_KICON_COLOR Qt::white

#include <klocale.h>

#include "knutnet.h"
#include "knutupsdata.h"
#include "knutconst.h"

#include <qcolor.h>
#include <qfont.h>
#include <qstring.h>


//  const char *nameUpsVars1[] = {
//    "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID","BATTVOLT","OUTVOLT","CURRENT","BATT_TEMP","BATT_CURRENT"};

//  const char *nameUpsVars2[] = {
//    "none", "input.voltage", "battery.charge", "ups.temperature", "input.frequency", "ups.load", "ambient.temperature", "ambient.humidity","battery.voltage","output.voltage","output.current","battery.temperature","battery.current"};
    

/**
  *@author Daniel Prynych
  */


  
struct ScaleStructDef {
  int start;
  int end;
  int scaleColor;
  };

struct VarStrucDef {
  QString nameAnalog; // jmeno promene v meraku  napr. UPS Load
  QString nameUnit; // merna jednotka napr %
  int typeAnalog; //typ meraku
  int numberItem; //pocet casti stupnice neni v souvislosti barvou
  int numberInItem; //pocet casti stupnice uvnitr dilku stupnice
  int start; // pocatecni hodnota v meraku
  int end; // konecna hodnota v meraku
  struct ScaleStructDef scaleData[5];
  };


struct SettingDataDef {
  int countCols;
  int x;
  int y;
  int width;
  int height;
  QColor mainBackgroundColor;
  QColor mPanelBackgroundColor;
  QColor aPanelBackgroundColor;
  QColor analogFingerColor;
  QColor analogOKColor;
  QColor analogWarnningColor;
  QColor analogErrorColor;
  QColor analogScaleColor;
  QColor analogFontColor;
  unsigned int panelFlags;
  int inputVoltage;
  int inputFrequency;
  bool lowHighXfer;
  bool areYouSure;
  bool useMainWindow;
  bool useMessageWindow;
  bool customBColor;
  bool customBPanelColor;
  bool customBAnalogColor;
  bool customOAnalogColor;
  QFont mPanelFont; // main panel font
  QFont aPanelFont; // analog panel font
  QFont systemFont; // system font
  bool customFont; // use custom font
  bool useDescription;
  unsigned int toolTipFlags;
  bool customKIconColor;
  QColor kIconBackgroundColor;
  int typeOfKIcon;
  };

  struct upsInfo{
    KNutNet *upsNet;
    struct upsRecord record;
    int netError; // kod chyby pri spojeni
    bool errorUpsData;
    // state of connection to usbd, this isn't state of knutnet
    knc::upsDriverConnection upsDriverState; // defined in knutconst.h
    int oldState; // code of lost state of UPS  kod posledniho stavu UPS
    QString name;
    QString password;
    int nutVariables;
    int nutProtocol;
    QString runtimeVar;
    QString lowxferVar;
    QString highxferVar;
    QString statusVar;
    QString upsLoadVar;
    bool reconnecting;  // is true when program is in reconnecting stage
    int reconnectCount; 
    };
    
 /**
  * Class contain data about analog panels,
  * name, ...
  * Trida obsahuje data o analogovych panelech,
  * nazev, atd.
  * Udava jak ma prislusny panel vypadat
  *
  * @author Daniel Prynych
  * @short INforamcion about analog panels
  * @version 0.3
  **/

class QString;
class QColor;
class QFont;  

class KNutVarData {
public:
  KNutVarData();
  ~KNutVarData();

 /**
  * Vrati data analogoveho mericiho panelu.
  * typ meraku, pocet dilku stupvice, merici jedntotku atd
  * data je mozno take nastavovat
  * @param seqNumber Kod typu meraky.
  * @param data Data pro zadany typ panelu.
  * @since  0.1
  **/
void getData(const int seqNumber, struct VarStrucDef& data);

 /**
  * Nastavi data analogoveho mericiho panelu.
  *
  * @param seqNumber Kod typu meraky.
  * @param data Data pro zadany typ panelu.
  *
  * @since  0.1
  **/
void putData (const int seqNumber, struct VarStrucDef& data);

 /**
  * Nastavi data analogoveho mericiho panelu pro vstupni a vystupni napeti.
  *
  * @param typeVoltage Typ vstupniho napeti 230/120.
  *
  * @since  0.1
  **/
void setVoltage (const int typeVoltage);

 /**
  * Nastavi data analogoveho mericiho panelu pro vstupni frekvence.
  *
  * @param typeFrequence Typ vstupni frekvence 50/60.
  *
  * @since  0.1
  **/
void setFrequency (const int typeFrequence);

 /**
  * Nastavi vnitrni cast vybarveni podle low/high xfer,
  * low/high-XFER udava rozpeti pri kterem UPS zpracovava napeti ze site.
  *
  * @param lowXfer Pocatecni hodnota.
  * @param highXfer Konecna hodnota.
  * @since  0.1
  **/
void setXfer (const float lowXfer, const float highXfer);

 /**
  * Vrati dlouhy nazev analogoveho panelu,
  * je to jmeno merene veliciny
  *
  * @param seqNumber Kod typu merakuss.
  * @since  0.1
  **/
QString getNameAnalogData (const int seqNumber);


/**
 * Prevede kod chyby na jeho textovou reprezentaci
 *
 * @since  0.2
 **/
  static const QString errorToText (const int error);


/**
 * Zobrazi jmeno chyby na zaklade jeho cisla.
 *
 * @since  0.1.2
 **/
  static void showError (const int error);
  

private:

  enum {aRegWhite,aRegGreen,aRegYellow,aRegRed,aRegBlue,aRegCyan,aRegMagenta,aRegBlack};

  struct VarStrucDef dataVar[ knc::NumberOfTypes ];  /* udrzuje popis Anagovych meraku pro danou promenou jmeno zabarveni typ meraky */
  struct VarStrucDef dataVarVoltage[2];
  struct VarStrucDef dataVarFrequence[2];

  static const int U230V = 0;
  static const int U120V = 1;
  static const int F50HZ = 0;
  static const int F60HZ = 1;

  QString upsVarNameAnalog[ knc::NumberOfTypes ];
};

#endif
