#!@l_prefix@/bin/php
<?php
/*
 *  Copyright (c) 2004 Klaraelvdalens Datakonsult AB
 *
 *    Writen by Steffen Hansen <steffen@klaralvdalens-datakonsult.se>
 *
 *  This  program is free  software; you can redistribute  it and/or
 *  modify it  under the terms of the GNU  General Public License as
 *  published by the  Free Software Foundation; either version 2, or
 *  (at your option) any later version.
 *
 *  This program is  distributed in the hope that it will be useful,
 *  but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You can view the  GNU General Public License, online, at the GNU
 *  Project's homepage; see <http://www.gnu.org/licenses/gpl.html>.
 */

/* Fix include_path to pick up our modified Horde classes */
$include_path = ini_get('include_path');
ini_set( 'include_path', 
	 '.:@l_prefix@/var/kolab/php:@l_prefix@/var/kolab/php/pear:'.$include_path);

require_once 'PEAR.php';
require_once 'kolabfilter/misc.php';
require_once 'kolabfilter/kolabmailtransport.php';

// Profiling code
/*
function mymtime(){
  $tmp=explode(' ',microtime());
  $rt=$tmp[0]+$tmp[1];
  return $rt;
}

class MyTimer {
  function MyTimer( $name ) {
    $this->name = $name;
  }
  function start() {
    $this->time = mymtime();
  }
  function stop() {
    $time = 100*(mymtime()-$this->time);
    myLog("Section ".$this->name." took $time msecs", RM_LOG_DEBUG);
  }

  var $name;
  var $time;
};

$totaltime =& new MyTimer("Total");
$totaltime->start();
*/

// Load our configuration file
$params = array();
require_once '@l_prefix@/etc/resmgr/resmgr.conf';
init();

define( 'TMPDIR', '@l_prefix@/var/resmgr/filter' );
define( 'EX_TEMPFAIL', 75 );
define( 'EX_UNAVAILABLE', 69 );

//$inputtime =& new MyTimer("Input");
//$inputtime->start();

// Temp file for storing the message
$tmpfname = tempnam( TMPDIR, 'IN.' );
$tmpf = @fopen($tmpfname, "w");
if( !$tmpf ) {
  myLog("Error: Could not open $tempfname for writing: ".php_error(), RM_LOG_ERROR);
  exit(EX_TEMPFAIL);  
}

// Cleanup function
function cleanup() {
  global $tmpfname;
  file_exists($tmpfname) && unlink($tmpfname);
}
register_shutdown_function( 'cleanup' );

function is_my_domain( $addr ) {
  global $params;
  if( is_array($params['email_domain']) ) {
	$domains = $params['email_domain'];
  } else {
	$domains = array($params['email_domain']);
  }
  
  $adrs = imap_rfc822_parse_adrlist($addr, $params['email_domain']);
  foreach ($adrs as $adr) {
    $adrdom = $adr->host;
    if( empty($adrdom) ) continue;
    foreach( $domains as $dom ) {
      if( $dom == $adrdom ) return true;
      if( $params['verify_subdomains'] && substr($adrdom, -strlen($dom)-1) == ".$dom" ) return true;
    }
  }
  return false;
}

function rewrite_from($sender,$from) {
  global $params;
  $adrs = imap_rfc822_parse_adrlist($from, $params['email_domain'][0]);
  foreach ($adrs as $adr) {
    $fromadr = $adr->mailbox.'@'.$adr->host;
    if( !ereg( "\(UNTRUSTED, sender is <$sender>\)", $from ) ) {
      myLog("$from is not an allowed From address for unauthenticated users, rewriting", RM_LOG_DEBUG);
      return '"'.str_replace(array("\\",'"'),array("\\\\",'\"'),$adr->personal).' (UNTRUSTED, sender is <'.$sender.'>)" '.'<'.$fromadr.'>';
    } /* else already rewritten */
  }
  return $from;
}

// Check that mail from our domains have trustable
// From: header and that mail from the outside
// does not impersonate any user from our domain
function verify_sender( $sender, $from, $client_addr ) {
  global $params;

  $adrs = imap_rfc822_parse_adrlist($from, $params['email_domain']);
  foreach ($adrs as $adr) {
    $from = $adr->mailbox.'@'.$adr->host;
    $fromdom = $adr->host;

    if( is_array($params['email_domain']) ) {
      $domains = $params['email_domain'];
    } else {
      $domains = array($params['email_domain']);
    }
    $senderdom = substr(strrchr($sender, '@'), 1);
    foreach( $domains as $domain ) {
      if( $params['verify_subdomains'] ) {	
		if( $client_addr != '127.0.0.1' && 
			($senderdom == $domain ||
			 $fromdom   == $domain ||
			 substr($senderdom, -strlen($domain)-1) == ".$domain" ||
			 substr($fromdom, -strlen($domain)-1) == ".$domain" ) &&
			$sender != $from ) {
		  return false;
		}
      } else {
		if( ($senderdom == $domain ||
			 $fromdom   == $domain ) &&
			$sender != $from ) {
		  return false;
		}
      }
    }
  }
  return true;
}

$options = parse_args( array( 's', 'r', 'c', 'h' ), $_SERVER['argv']); //getopt("s:r:c:h:");

if (!array_key_exists('r', $options) || !array_key_exists('s', $options)) {
    fwrite(STDOUT, "Usage is $argv[0] -s sender@domain -r recip@domain\n");
    exit(EX_TEMPFAIL);
}

$sender = strtolower($options['s']);
$recipients = $options['r'];
$client_address = $options['c'];
$fqhostname = strtolower($options['h']);

// make sure recipients is an array
if( !is_array($recipients) ) {
  $recipients = array( $recipients );
}

// make recipients lowercase
for( $i = 0; $i < count($recipients); $i++ ) {
  $recipients[$i] = strtolower($recipients[$i]);
}

myLog("Kolabfilter starting up, sender=$sender, recipients=".join(',', $recipients)
      .", client_address=$client_address", RM_LOG_DEBUG);

$ical = false;
$from = false;
$subject = false;
$senderok = true;
$rewrittenfrom = false;

define( RM_STATE_READING_HEADER, 1 );
define( RM_STATE_READING_FROM,   2 );
define( RM_STATE_READING_SUBJECT,3 );
define( RM_STATE_READING_SENDER, 4 );
define( RM_STATE_READING_BODY,   5 );

$state = RM_STATE_READING_HEADER;

while (!feof(STDIN) && $state != RM_STATE_READING_BODY) {
  $buffer = fgets(STDIN, 8192);
  $line = rtrim( $buffer, "\r\n");
  if( $line == '' ) {
    // Done with headers
    $state = RM_STATE_READING_BODY;
    if( $from && $params['verify_from_header'] ) {
      if( !verify_sender( strtolower($sender), strtolower($from), $client_address) ) {
		myLog("$sender and $from differ!", RM_LOG_DEBUG);
		if( $params['reject_forged_from_header'] ) {
		  // Always reject mismatches
		  $senderok = false;
		} else {
		  // Only rewrite if from is ours and envelope not
		  if( is_my_domain( $from ) && !is_my_domain( $sender )) {
		    $rewrittenfrom = "From: ".rewrite_from( $sender, $from )."\r\n";
		  } else {
		    // Not our domain in From, reject
		    $senderok = false;			
		  }
		}
      }
    }
  } else {
    if( $line[0] != ' ' && $line[0] != "\t" ) $state = RM_STATE_READING_HEADER;
    switch( $state ) {
    case RM_STATE_READING_HEADER:
      if( $params['allow_sender_header'] && eregi( '^Sender: (.*)', $line, $regs ) ) {
	$from = $regs[1];
	$state = RM_STATE_READING_SENDER;
      } else if( !$from && eregi( '^From: (.*)', $line, $regs ) ) {
	$from = $regs[1];
	$state = RM_STATE_READING_FROM;
      } else if( eregi( '^Subject: (.*)', $line, $regs ) ) {
	$subject = $regs[1];
	$state = RM_STATE_READING_SUBJECT;
      } else if( eregi( '^Content-Type: text/calendar', $line ) ) {
	myLog("Found iCal data in message", RM_LOG_DEBUG);
	$ical = true;
      }
      break;
    case RM_STATE_READING_FROM:
      $from .= $line;
      break;
    case RM_STATE_READING_SENDER:
      $from .= $line;
      break;
    case RM_STATE_READING_SUBJECT:
      $subject .= $line;
      break;
    }
  }
  if( fwrite($tmpf, $buffer) === false ) {
    exit(EX_TEMPFAIL);
  }
}
while (!feof(STDIN)) {
  $buffer = fread( STDIN, 8192 );
  if( fwrite($tmpf, $buffer) === false ) {
    exit(EX_TEMPFAIL);
  }
}
fclose($tmpf);

//$inputtime->stop();

if( !$senderok ) {
  if( $ical && $params['allow_outlook_ical_forward'] ) {
    require_once('kolabfilter/olhacks.php');
    $rc = olhacks_embedical( $fqhostname, $sender, $recipients, $from, $subject, $tmpfname );
    if( PEAR::isError( $rc ) ) {
      fwrite(STDOUT,"Filter failed: ".$rc->getMessage()."\n");
      exit(EX_TEMPFAIL);
    } else if( $rc === true ) {
      exit(0);
    }
  } else {
    myLog("Invalid From: header. $from does not match envelope $sender\n", RM_LOG_DEBUG);
    fwrite(STDOUT,"Invalid From: header. $from does not match envelope $sender\n");
    exit(EX_UNAVAILABLE);
  }
}

//$outputtime =& new MyTimer("Output");
//$outputtime->start();

$tmpf = @fopen($tmpfname,"r");
if( !$tmpf ) {
  myLog("Error: Could not open $tempfname for reading: ".php_error(), RM_LOG_ERROR);
  exit(EX_TEMPFAIL);  
}

$smtp = new KolabSMTP( 'localhost', 10026 );
if( PEAR::isError( $smtp ) ) {
  fwrite(STDOUT, $error->getMessage().", code ".$error->getCode()."\n"); 
  if( $error->getCode() < 500 ) exit(EX_TEMPFAIL);
  else exit(EX_UNAVAILABLE);
}
if( PEAR::isError( $error = $smtp->start($sender,$recipients) ) ) {
  fwrite(STDOUT, $error->getMessage().", code ".$error->getCode()."\n"); 
  if( $error->getCode() < 500 ) exit(EX_TEMPFAIL);
  else exit(EX_UNAVAILABLE);
}

$state = RM_STATE_READING_HEADER;
while (!feof($tmpf) && $state != RM_STATE_READING_BODY) {
  $buffer = fgets($tmpf, 8192);
  if( $rewrittenfrom ) {
    if( eregi( '^From: (.*)', $buffer ) ) {
      if( PEAR::isError($error = $smtp->data( $rewrittenfrom )) ) {
	$str = $error->getMessage().", code ".$error->getCode();
	myLog($str,RM_LOG_ERROR);
	fwrite(STDOUT, $str."\n"); 
	if( $error->getCode() < 500 ) exit(EX_TEMPFAIL);
	else exit(EX_UNAVAILABLE);
      }
      $state = RM_STATE_READING_FROM;
      continue;
    } else if( $state == RM_STATE_READING_FROM && 
	       ($buffer[0] == ' ' || $buffer[0] == "\t" ) ) {
      // Folded From header, ignore
      continue;
    }
  }
  if( $buffer[0] != ' ' && $buffer[0] != "\t" ) {
    $state = RM_STATE_READING_HEADER;    
  }
  if( rtrim( $buffer, "\r\n" ) == '' ) {
    $state = RM_STATE_READING_BODY;
  }
  if( PEAR::isError($error = $smtp->data( $buffer )) ) {
    $str = $error->getMessage().", code ".$error->getCode();
    myLog($str,RM_LOG_ERROR);
    fwrite(STDOUT, $str."\n"); 
    if( $error->getCode() < 500 ) exit(EX_TEMPFAIL);
    else exit(EX_UNAVAILABLE);
  }
}
while (!feof($tmpf) ) {
    $buffer = fread($tmpf, 8192);
    $len = strlen($buffer);

    /* We can't tolerate that the buffer breaks the data
       between \r and \n, so we try to avoid that. The limit
       of 100 reads is to battle abuse */
    while( $buffer{$len-1} == "\r" && $len < 8192 + 100 ) {
      $buffer .= fread($tmpf,1);
      $len++;
    }
    if( PEAR::isError($error = $smtp->data( $buffer )) ) {
        fwrite(STDOUT, $error->getMessage().", code ".$error->getCode()."\n"); 
	if( $error->getCode() < 500 ) exit(EX_TEMPFAIL);
	else exit(EX_UNAVAILABLE);
    }
};

$smtp->end();
//$outputtime->stop();
myLog("Kolabfilter successfully completed", RM_LOG_DEBUG);
//$totaltime->stop();
exit(0);
?>
