/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIG_H
#define CONFIG_H

#include <qdom.h>
#include <menulistviewitem.h>

#include "kommando.h"
#include "commandobutton.h"
#include "kommandoview.h"

class QWidgetStack;

class Config{
    public:
        static Config& getSingleton(){
            static Config instance;
            return instance;
        }

        ~Config();

        bool readConfigFile();
        bool writeConfigFile();
        void fromConfigDlg(KommandoViewList& listViews);
        void toListView(KommandoViewList& listViews, QWidgetStack* listViewParent);
        void toKommandoMenu(Kommando* buttonParent);
        void setDefaultValues();

        void setShortcut(const QString& cut){ mShortcut = cut; }
        QString Shortcut() const{ return mShortcut; }

        void setTintColor(const QColor& theValue){ mTintColor = theValue; }
        QColor tintColor() const { return mTintColor; }

        void setOpacity(const float value){mOpacity=value;}
        float opacity() const {return mOpacity;}

        void setMenuButtonSize(unsigned short theValue){ mMenuButtonSize = theValue; }
        unsigned short menuButtonSize() const { return mMenuButtonSize; }

        void setNavButtonSize (unsigned short theValue){ mNavButtonSize = theValue; }
        unsigned short navButtonSize() const { return mNavButtonSize; }

        void setMenuRadius(unsigned int theValue){ mMenuRadius = theValue; }
        unsigned int menuSize() const { return mMenuRadius*2; }
        unsigned int menuRadius() const{ return mMenuRadius; }
        unsigned int buttonDistance() const { return (mMenuRadius-static_cast<int>(mMenuButtonSize*1.38)); }

        void setScheme(const QString& theValue){ mScheme = theValue; }
        QString scheme() const{ return mScheme; }

    protected:
        Config();
        Config(const Config&);
        void createDefaultConfigFile();
    
        QString mConfigPath;
        QString mShortcut;
        QColor mTintColor;
        float mOpacity;
        QString mScheme;
        unsigned short mMenuButtonSize;
        unsigned short mNavButtonSize;
        unsigned int mMenuRadius;
        bool mAddDefalutMenuLink;
        QDomDocument* doc;

        //Factory functions
        Menu* menuFromXML(const QDomElement& ownNode, Kommando* buttonParent, Menu* parent=NULL);
        CommandoButton* comButtonFromXML(const QDomElement& ownNode, Kommando* parent);
        QListView* newListView(QWidget * parent, const char* name);

        void menuItemToXML(QDomNode& parent, MenuListViewItem* item);

        //The following 3 methods could have been implemented in just 1 method, if there would be no need in overriding the parent argument
        //so I put the code both menuItemFromXML methods share in itemHelper to reduce redundancy
        void menuItemFromXML(KommandoView* parent,  QListViewItem* after, const QDomElement& ownNode);
        void menuItemFromXML(QListViewItem* parent,  QListViewItem* after, const QDomElement& ownNode);
        void itemHelper(const QDomElement& ownNode, MenuListViewItem* item);

        //Some factory functions that allow to setup a xml file quickly
        QDomElement newNode(const QString& nodename, QDomNode& parent, int value);
        QDomElement newNode(const QString& nodename, QDomNode& parent, float value);
        QDomElement newNode(const QString& nodename, QDomNode& parent, const QString& value);
        QDomElement newNode(const QString& nodename, QDomNode& parent, const QString& value, const QString& attrname, const QString& attrvalue);
        QDomElement newButton(QDomNode& parent, const QString& icon, const QString& command);
        QDomElement newMenu(QDomNode& parent, const QString& appName = QString::null, const QString& icon = QString::null);
};

#endif
