/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kconfig.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kfiledialog.h>
#include <kdialogbase.h>
#include <kmessagebox.h>
#include <kstdguiitem.h>

#include <qwidgetstack.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qscrollview.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qfile.h>
#include <qtooltip.h>

#include "kompilemainwidget.h"
#include "kompileprofiledialog.h"
#include "kompileinstalledpackagewidget.h"
#include "kompileprofileselectionwidget.h"
#include "kompilemanageprofileswidget.h"
#include "kompilesetupdialog.h"
#include "kompilewidget.h"

KompileMainWidget::KompileMainWidget(QWidget *parent, const char *name)
    :KompileMainWidgetBase (parent, name)
{
  this->parent = (Kompile*) parent;

  btnInstall->setPixmap(KGlobal::iconLoader()->loadIcon("kpackage", KIcon::Desktop, 64));
  btnAdmin->setPixmap(KGlobal::iconLoader()->loadIcon("kcontrol", KIcon::Desktop, 64));
  btnUninstall->setPixmap(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::Desktop, 64));

  btnInstallationStandard->setPixmap(KGlobal::iconLoader()->loadIcon("gear", KIcon::Desktop, 48));
  btnInstallationProfiled->setPixmap(KGlobal::iconLoader()->loadIcon("tar", KIcon::Desktop, 48));
  btnUninstallationStandard->setPixmap(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::Desktop, 48));
  btnUninstallationProfiled->setPixmap(KGlobal::iconLoader()->loadIcon("kontact_todo.png", KIcon::Desktop, 48));
  btnManageProfiles->setPixmap(KGlobal::iconLoader()->loadIcon("kontact_notes.png", KIcon::Desktop, 48));
  btnKompileSetup->setPixmap(KGlobal::iconLoader()->loadIcon("kcmsystem", KIcon::Desktop, 48));
  btnExit->setIconSet(KGlobal::iconLoader()->loadIcon("exit", KIcon::Desktop, 22));

  wstOperation->hide();
  adjustSize();
}

void KompileMainWidget::bgOperations_clicked(int id)
{
  if (!wstOperation->isVisible())
  {
    wstOperation->show();
    adjustSize();
  }

  if (id == wstOperation->id(wstOperation->visibleWidget()))
  {
    bgOperations->setButton(-1);
  }
  else
  {
    wstOperation->raiseWidget(id);
  }
}

void KompileMainWidget::btnInstallationStandard_clicked()
{
  QString tarball = KFileDialog::getOpenFileName("", "*.tar *.tar.gz *.tar.gz2 *.tgz *.tar.bz *.tar.bz2|" + tr2i18n("Source Tarball Archives"), this, tr2i18n("Select source tarball to install"));
  if (tarball.isEmpty())
    return;


  QStringList path_tokens = QStringList::split("/", tarball);
  QStringList file_tokens = QStringList::split(".t", path_tokens[path_tokens.count() - 1]);
  QStringList tarball_datas = QStringList::split("-", file_tokens[0]);
  QString profile_filename(locateLocal("appdata", "") + "/" + file_tokens[0] + ".komprof");

  QFile profile_file(profile_filename);
  if (profile_file.exists() && KMessageBox::warningYesNo(this, tr2i18n("Already exists a profile for selected sources tarball.\nconsider to use \"Repair function\" in Repair/Remove section to repair package, if it's installed\nor use \"Profiled Installation\" with \"Load Profile\" function.\n\nDo you want to continue with default installation and overwrite old profile?"), tr2i18n("Provile already exists")) == KMessageBox::No)
    return;

  KConfig * default_profile = new KConfig(locateLocal("appdata", "") + "/default-profile.komprof");

  KConfig * profile = new KConfig(profile_filename);

  profile->writeEntry("use_decompression_user_dir", default_profile->readEntry("use_decompression_user_dir", ""));
  profile->writeEntry("use_checkinstall", default_profile->readEntry("use_checkinstall", ""));
  profile->writeEntry("simple_user_install_path", default_profile->readEntry("simple_user_install_path", ""));
  profile->writeEntry("simple_user_install_mode", default_profile->readEntry("simple_user_install_mode", ""));
  profile->writeEntry("remove_decompression_user_dir", default_profile->readEntry("remove_decompression_user_dir", ""));
  profile->writeEntry("license", default_profile->readEntry("license", ""));
  profile->writeEntry("installed", default_profile->readEntry("installed", ""));
  profile->writeEntry("do_not_install", default_profile->readEntry("do_not_install", ""));
  profile->writeEntry("description", default_profile->readEntry("description", ""));
  profile->writeEntry("decompression_user_dir", default_profile->readEntry("decompression_user_dir", ""));
  profile->writeEntry("configuration_options", default_profile->readEntry("configuration_options", ""));
  profile->writeEntry("checkinstall_path", default_profile->readEntry("checkinstall_path", ""));
  profile->writeEntry("checkinstall_package_type", default_profile->readEntry("checkinstall_package_type", ""));
  profile->writeEntry("archive_tarball", default_profile->readEntry("archive_tarball", ""));
  profile->writeEntry("LDFLAGS", default_profile->readEntry("LDFLAGS", ""));
  profile->writeEntry("FFLAGS", default_profile->readEntry("FFLAGS", ""));
  profile->writeEntry("FF", default_profile->readEntry("FF", ""));
  profile->writeEntry("CXXFLAGS", default_profile->readEntry("CXXFLAGS", ""));
  profile->writeEntry("CXXCPP", default_profile->readEntry("CXXCPP", ""));
  profile->writeEntry("CXX", default_profile->readEntry("CXX", ""));
  profile->writeEntry("CPPFLAGS", default_profile->readEntry("CPPFLAGS", ""));
  profile->writeEntry("CPP", default_profile->readEntry("CPP", ""));
  profile->writeEntry("CFLAGS", default_profile->readEntry("CFLAGS", ""));
  profile->writeEntry("CC", default_profile->readEntry("CC", ""));

  profile->writeEntry("tarball", tarball);
  profile->writeEntry("name", tarball_datas[0]);
  if (tarball_datas.count() > 1)
    profile->writeEntry("version", tarball_datas[1]);
  if (tarball_datas.count() > 2)
    profile->writeEntry("release", tarball_datas[2]);

  profile->sync();
  delete default_profile;


  KDialogBase * installdialog = new KDialogBase(this, "KompileInstall", TRUE, tr2i18n("Installing ") + tarball, 0);
  KompileWidget * installwidget = new KompileWidget(profile, KompileWidget::OPERATION_INSTALL, installdialog);
  installdialog->setMainWidget( installwidget );
  parent->hide();
  installdialog->adjustSize();
  installdialog->exec();
  while (installwidget->getStatus() != KompileWidget::STATUS_FINISHED && installwidget->getStatus() != KompileWidget::STATUS_ABORTED && installwidget->getStatus() != KompileWidget::STATUS_ERROR);
  parent->show();
  delete profile;
  delete installwidget;
  delete installdialog;
}

void KompileMainWidget::btnInstallationProfiled_clicked()
{
  KompileProfileDialog * profiledialog = new KompileProfileDialog(this, "KompileInstallProfile");
  profiledialog->adjustSize();
  parent->hide();

  int result = profiledialog->exec();

  if (profiledialog->getProfile() != NULL)
  {
    KConfig * profile = profiledialog->getProfile();
    KDialogBase * installdialog = new KDialogBase(this, "KompileInstall", TRUE, tr2i18n("Installing ") + profile->readEntry("tarball", ""), 0);
    KompileWidget * installwidget = new KompileWidget(profile,  KompileWidget::OPERATION_INSTALL, installdialog);

    installdialog->setMainWidget( installwidget );
    installdialog->adjustSize();
    installdialog->exec();


    delete installwidget;
    delete installdialog;
    delete profile;
  }

  parent->show();
  delete profiledialog;
}

void KompileMainWidget::btnUninstallationStandard_clicked()
{
  QString tarball = KFileDialog::getOpenFileName("", "*.tar *.tar.gz *.tar.gz2 *.tgz *.tar.bz *.tar.bz2|" + tr2i18n("Source Tarball Archives"), this, tr2i18n("Select source tarball to uninstall"));
  if (tarball.isEmpty())
    return;

  KDialogBase * installdialog = new KDialogBase(this, "KompileUninstall", TRUE, tr2i18n("Uninstalling ") + tarball, 0);
  KConfig * profile = new KConfig(locateLocal("appdata", "") + "/default-profile.komprof");
  profile->writeEntry("tarball", tarball);
  KompileWidget * installwidget = new KompileWidget(profile,  KompileWidget::OPERATION_UNINSTALL, installdialog);

  installdialog->setMainWidget( installwidget );
  parent->hide();
  installdialog->adjustSize();
  installdialog->exec();
  parent->show();
  delete profile;
  delete installwidget;
  delete installdialog;
}

void KompileMainWidget::btnUninstallationProfiled_clicked()
{
  parent->hide();
  KDialogBase * installed_packages = new KDialogBase(this, "InstalledPackages", TRUE, tr2i18n("Repair/Remove Installed Packages"), KDialogBase::Close);

  QDir * dir =  new QDir(locateLocal("appdata", ""));
  QStringList profiles = dir->entryList("*.komprof");
  delete dir;

  QScrollView * installed_packages_list = new QScrollView(installed_packages);
  installed_packages->setMainWidget(installed_packages_list);
  QVBox * v_box = new QVBox(installed_packages_list->viewport());
  installed_packages_list->addChild(v_box);
  installed_packages_list->setResizePolicy(QScrollView::AutoOneFit);

  int y_pos = 0;

  for ( QStringList::Iterator profile = profiles.begin(); profile != profiles.end(); ++profile )
  {
    if ((*profile).compare("default-profile.komprof") == 0)
      continue;

    KConfig * profile_config = new KConfig(locateLocal("appdata", "") + "/" + *profile);


    if (profile_config->readEntry("installed", "false") == "false")
      continue;

    KompileInstalledPackageWidget * installed = new KompileInstalledPackageWidget(profile_config, installed_packages, v_box);

  }

  installed_packages->exec();
  installed_packages_list->adjustSize();
  adjustSize();
  parent->show();
}

void KompileMainWidget::btnManageProfiles_clicked()
{
  KDialogBase * managedialog = new KDialogBase(this, "ProfilesManager", TRUE, tr2i18n("Manage Profiles"), 0);
  KompileManageProfilesWidget * managewidget = new KompileManageProfilesWidget( managedialog, "ProfilesManagerWidget" );
  managedialog->setMainWidget( managewidget );
  managedialog->adjustSize();
  managedialog->exec();

  delete managewidget;
  delete managedialog;
}

void KompileMainWidget::btnRollbackPackage_clicked()
{
  int result = KMessageBox::warningYesNo(this, i18n("Now Kompile uninstall profile specified application and try to reinstall it.\nIf you are sure that \"tarball\" voice point to a valid source tarball you can proced with rollback.\nDo you want perform package rollback?"), i18n("Rollbak package"));

  if (result == KMessageBox::No || result == KMessageBox::Cancel)
    return;

  KDialogBase * load_profile = new KDialogBase(this, "LoadProfile", TRUE, tr2i18n("Select existing profile"), KDialogBase::Ok|KDialogBase::Cancel);

  KompileProfileSelectionWidget * wgt = new KompileProfileSelectionWidget(load_profile);
  load_profile->setMainWidget(wgt);
  load_profile->adjustSize();

  if (load_profile->exec() == KDialogBase::Cancel)
    return;

  KConfig * profile = new KConfig(locateLocal("appdata", "") + "/" + wgt->selectedProfile() + ".komprof");

  parent->hide();
  KDialogBase * installdialog = new KDialogBase(this, "KompileUninstall", TRUE, tr2i18n("Uninstalling ") + profile->readEntry("tarball", ""), 0);
  KompileWidget * installwidget = new KompileWidget(profile,  KompileWidget::OPERATION_UNINSTALL, installdialog);
  installwidget->seconds_left = 1;
  installwidget->chkAutoclose->setChecked(TRUE);
  installwidget->chkAutoclose->setEnabled(FALSE);
  installdialog->setMainWidget( installwidget );
  installdialog->adjustSize();
  installdialog->exec();

  delete installwidget;
  delete installdialog;

  installdialog = new KDialogBase(this, "KompileInstall", TRUE, tr2i18n("Installing ") + profile->readEntry("tarball", ""), 0);
  installwidget = new KompileWidget(profile, KompileWidget::OPERATION_INSTALL, installdialog);
  installwidget->seconds_left = 1;
  installwidget->chkAutoclose->setChecked(TRUE);
  installwidget->chkAutoclose->setEnabled(FALSE);
  installdialog->setMainWidget( installwidget );
  installdialog->adjustSize();
  installdialog->exec();


  delete installdialog;
  delete installwidget;
  delete profile;
  parent->show();

  delete wgt;
  delete load_profile;
}

void KompileMainWidget::btnKompileSetup_clicked()
{
  KompileSetupDialog * setup = new KompileSetupDialog(this, "KompileSetup");
  setup->exec();
  delete setup;
}

void KompileMainWidget::btnExit_clicked()
{
    int res = KMessageBox:: questionYesNo (this, tr2i18n("Are you sure you want exit Kompile?"), tr2i18n("Exit Kompile"), KStdGuiItem::yes(), KStdGuiItem::no(), "ask_exit");

    if (res == KMessageBox::Yes)
        parent->close();
}




#include "kompilemainwidget.moc"
