/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kompilemanageprofileswidget.h"

#include <kstandarddirs.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kiconloader.h>

#include <qtable.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qdir.h>


#include "kompilewidget.h"
#include "kompileprofileselectionwidget.h"
#include "kompileprofilewidget.h"
#include "kompileprofiledialog.h"

KompileManageProfilesWidget::KompileManageProfilesWidget(QWidget *parent, const char *name)
    :KompileManageProfilesWidgetBase(parent, name)
{
  this->parent = (KDialogBase *) parent;

  tblProfiles->setLeftMargin(0);
  tblProfileInfo->setLeftMargin(0);
  tblProfileInfo->setTopMargin(0);

  btnClose->setIconSet(KGlobal::iconLoader()->loadIcon("ok", KIcon::Desktop, 16));
  btnModify->setIconSet(KGlobal::iconLoader()->loadIcon("configure", KIcon::Desktop, 16));
  btnDelete->setIconSet(KGlobal::iconLoader()->loadIcon("cancel", KIcon::Desktop, 16));

  refreshProfiles();
  tblProfiles->setCurrentCell(0,0);
  tblProfiles_selectionChanged();
}

void KompileManageProfilesWidget::refreshProfiles()
{
  QDir * dir =  new QDir(locateLocal("appdata", ""));
  QStringList profiles = dir->entryList("*.komprof");
  delete dir;

  tblProfiles->setNumRows(0);
  int row = 0;
  for (QStringList::Iterator profile = profiles.begin(); profile != profiles.end(); ++profile)
  {
    QString profile_name(*profile);

    profile_name.setLength( profile_name.length() - 8 );
    if (profile_name == "default-profile")
      continue;

    QStringList profile_info = QStringList::split( "-", profile_name );
    tblProfiles->setNumRows( tblProfiles->numRows() + 1 );

    for (int infos = 0; infos < profile_info.count(); infos++)
    {
      tblProfiles->setText(row, infos, profile_info[infos]);
    }

    row++;
  }


  btnDelete->setEnabled(FALSE);
  btnModify->setEnabled(FALSE);
  adjustSize();
}

void KompileManageProfilesWidget::tblProfiles_selectionChanged()
{
  if (!gbProfileInfo->isVisible())
  {
    gbProfileInfo->show();
  }

  if (!btnDelete->isEnabled())
    btnDelete->setEnabled(TRUE);

  if (!btnModify->isEnabled())
    btnModify->setEnabled(TRUE);

  QString profile_name(tblProfiles->text(tblProfiles->currentRow(), 0));

  if (!tblProfiles->text(tblProfiles->currentRow(), 1).isEmpty())
    profile_name.append("-" + tblProfiles->text(tblProfiles->currentRow(), 1));

  if (!tblProfiles->text(tblProfiles->currentRow(), 2).isEmpty())
    profile_name.append("-" + tblProfiles->text(tblProfiles->currentRow(), 2));



  lblProfileName->setText("Profile: <b>" + profile_name + "</b>");

  profile_name.append( ".komprof");

  KConfig * profile = new KConfig(locateLocal("appdata", "") + profile_name);

  tblProfileInfo->setText(0, 0, tr2i18n("Name"));
  tblProfileInfo->setText(0, 1, profile->readEntry( "name", "" ));
  tblProfileInfo->setText(1, 0, tr2i18n("Version"));
  tblProfileInfo->setText(1, 1, profile->readEntry( "version", "" ));
  tblProfileInfo->setText(2, 0, tr2i18n("Release"));
  tblProfileInfo->setText(2, 1, profile->readEntry( "release", "" ));
  tblProfileInfo->setText(3, 0, tr2i18n("License"));
  tblProfileInfo->setText(3, 1, profile->readEntry( "license", "" ));
  tblProfileInfo->setText(4, 0, tr2i18n("Description"));
  tblProfileInfo->setText(4, 1, profile->readEntry( "description", "" ));
  tblProfileInfo->setText(5, 0, tr2i18n("Package installed"));
  tblProfileInfo->setText(5, 1, profile->readEntry( "installed", "false" ));
  tblProfileInfo->setText(6, 0, tr2i18n("Source tarball"));
  tblProfileInfo->setText(6, 1, profile->readEntry( "tarball", "" ));
  tblProfileInfo->setText(7, 0, tr2i18n("Archive tarball"));
  tblProfileInfo->setText(7, 1, profile->readEntry( "archive_tarball", "false" ));
  tblProfileInfo->setText(8, 0, tr2i18n("Decompression directory"));
  tblProfileInfo->setText(8, 1, profile->readEntry( "decompression_user_dir", "" ));
  tblProfileInfo->setText(9, 0, tr2i18n("Decompression directory auto remove"));
  tblProfileInfo->setText(9, 1, profile->readEntry( "remove_decompression_user_dir", "false" ));
  tblProfileInfo->setText(10, 0, tr2i18n("Configuration flags"));
  tblProfileInfo->setText(10, 1, profile->readEntry( "configuration_options", "" ));
  tblProfileInfo->setText(11, 0, tr2i18n("C preprocessor flags"));
  tblProfileInfo->setText(11, 1, profile->readEntry( "CPP", "" ));
  tblProfileInfo->setText(12, 0, tr2i18n("C compiler executable"));
  tblProfileInfo->setText(12, 1, profile->readEntry( "CC", "" ));
  tblProfileInfo->setText(13, 0, tr2i18n("C compiler flags"));
  tblProfileInfo->setText(13, 1, profile->readEntry( "CFLAGS", "" ));
  tblProfileInfo->setText(14, 0, tr2i18n("C++ preprocessor flags"));
  tblProfileInfo->setText(14, 1, profile->readEntry( "CXXCPP", "" ));
  tblProfileInfo->setText(15, 0, tr2i18n("C++ compiler executable"));
  tblProfileInfo->setText(15, 1, profile->readEntry( "CXX", "" ));
  tblProfileInfo->setText(16, 0, tr2i18n("C++ compiler flags"));
  tblProfileInfo->setText(16, 1, profile->readEntry( "CXXFLAGS", "" ));
  tblProfileInfo->setText(17, 0, tr2i18n("C/C++ preprocessor flags"));
  tblProfileInfo->setText(17, 1, profile->readEntry( "CPPFLAGS", "" ));
  tblProfileInfo->setText(18, 0, tr2i18n("Fortran compiler executable"));
  tblProfileInfo->setText(18, 1, profile->readEntry( "FF", "" ));
  tblProfileInfo->setText(19, 0, tr2i18n("Fortran compiler flags"));
  tblProfileInfo->setText(19, 1, profile->readEntry( "FFLAGS", "" ));
  tblProfileInfo->setText(20, 0, tr2i18n("Linker flags"));
  tblProfileInfo->setText(20, 1, profile->readEntry( "LDFAGS", "" ));
  tblProfileInfo->setText(21, 0, tr2i18n("Skip package installation"));
  tblProfileInfo->setText(21, 1, profile->readEntry( "do_not_install", "" ));
  tblProfileInfo->setText(22, 0, tr2i18n("Use Checkinstall"));
  tblProfileInfo->setText(22, 1, profile->readEntry( "use_checkinstall", "false" ));
  tblProfileInfo->setText(23, 0, tr2i18n("Checkinstall executable"));
  tblProfileInfo->setText(23, 1, profile->readEntry( "checkinstall_path", "" ));
  tblProfileInfo->setText(24, 0, tr2i18n("Checkinstall output package for"));
  tblProfileInfo->setText(24, 1, profile->readEntry( "checkinstall_package_type", "" ));

  tblProfileInfo->setText(25, 0, tr2i18n("Simple user install mode"));
  QString user_install_mode = profile->readEntry("simple_user_install_mode", "su");

  if (user_install_mode == "ask")
    tblProfileInfo->setText(25, 1, tr2i18n("Ask root password and install as super user"));
  else if (user_install_mode == "dir")
    tblProfileInfo->setText(25, 1, tr2i18n("Alaways ask user what he &wants to do"));
  else
    tblProfileInfo->setText(25, 1, tr2i18n("Install as simple user in specified folder"));


  tblProfileInfo->setText(26, 0, tr2i18n("Simple user installation folder"));
  tblProfileInfo->setText(26, 1, profile->readEntry( "simple_user_install_path", "" ));

  tblProfileInfo->adjustColumn(0);
  tblProfileInfo->adjustColumn(1);

  parent->adjustSize();
  delete profile;
}

void KompileManageProfilesWidget::btnClose_clicked()
{
  parent->close();
}

void KompileManageProfilesWidget::btnDelete_clicked()
{
  QString profile_name(tblProfiles->text(tblProfiles->currentRow(), 0));

  if (!tblProfiles->text(tblProfiles->currentRow(), 1).isEmpty())
    profile_name.append("-" + tblProfiles->text(tblProfiles->currentRow(), 1));

  if (!tblProfiles->text(tblProfiles->currentRow(), 2).isEmpty())
    profile_name.append("-" + tblProfiles->text(tblProfiles->currentRow(), 2));

  int result = KMessageBox::warningYesNo(this, i18n("Are you sure you want remove profile \"") + profile_name + "\"?", i18n("Remove profile"));

  if (result == KMessageBox::No || result == KMessageBox::Cancel)
    return;

  profile_name.append( ".komprof");
  QDir * dir = new QDir();
  dir->remove(locateLocal( "appdata", "" ) + "/" + profile_name);
  delete dir;

  refreshProfiles();
}

void KompileManageProfilesWidget::btnModify_clicked()
{
  QString profile_name(tblProfiles->text(tblProfiles->currentRow(), 0));

  if (!tblProfiles->text(tblProfiles->currentRow(), 1).isEmpty())
    profile_name.append("-" + tblProfiles->text(tblProfiles->currentRow(), 1));

  if (!tblProfiles->text(tblProfiles->currentRow(), 2).isEmpty())
    profile_name.append("-" + tblProfiles->text(tblProfiles->currentRow(), 2));

  KompileProfileDialog * profiledialog = new KompileProfileDialog(this, "KompileInstallProfile");
  KompileProfileWidget * profilewidget = new KompileProfileWidget(profiledialog, "KompileInstallProfile");
  profilewidget->loadProfile( profile_name );
  profiledialog->setMainWidget(profilewidget);
  profiledialog->adjustSize();
  profiledialog->exec();

  delete profilewidget;
  delete profiledialog;
  refreshProfiles();
}

#include "kompilemanageprofileswidget.moc"
