/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdialogbase.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kconfig.h>

#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qfileinfo.h>
#include <qdir.h>

#include "kompilesetupdialog.h"
#include "kompilesetupgeneral.h"
#include "kompileprofilewidget.h"

KompileSetupDialog::KompileSetupDialog(QWidget *parent, const char *name) : KDialogBase(KDialogBase::IconList, Qt::WType_Dialog, parent, name, TRUE, tr2i18n("Kompile Setup"), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok)
{
  QFrame * general = addPage(i18n("General"), i18n("General options"), KGlobal::iconLoader()->loadIcon("mycomputer",KIcon::Panel,0,false));
  QVBoxLayout *frameLayout = new QVBoxLayout( general, 0, 0 );
  general_widget = new KompileSetupGeneral(general, "KompileSetupGeneralWidget");
  frameLayout->addWidget(general_widget);

  QFrame * default_profile = addPage(i18n("Default Profile"), i18n("Setup Default Profile"), KGlobal::iconLoader()->loadIcon("kcmdf",KIcon::Panel,0,false));
  frameLayout = new QVBoxLayout( default_profile, 0, 0 );
  QString def_prof("default-profile");
  default_profile_widget = new KompileProfileWidget(def_prof, default_profile, "ProfileWidget");
  frameLayout->addWidget(default_profile_widget);

  connect (this, SIGNAL(okClicked()), this, SLOT(okButton_Clicked()));

  adjustSize();
}

void KompileSetupDialog::okButton_Clicked()
{
  KConfig * config = KGlobal::config();
  config->setGroup("General");

  if (general_widget->bgIntegration->selectedId() == 1)
  {
    config->writeEntry("kde_integration_type", "standalone");
    writeServiceMenu(TRUE);
  }
  else
  {
    config->writeEntry("kde_integration_type", "actions");
    writeServiceMenu(FALSE);
  }

  if (general_widget->chkAutoclose->isChecked())
    config->writeEntry("autoclose_enabled", "true");
  else
    config->writeEntry("autoclose_enabled", "false");

  config->writeEntry("autoclose_seconds", general_widget->txtAutocloseSeconds->value());
  config->writeEntry("sound_noerrors", general_widget->txtSoundNoErrors->text());
  config->writeEntry("sound_fails", general_widget->txtSoundFails->text());

  config->setGroup("Notification Messages");  
  if (general_widget->chkAskExit->isChecked())
    config->writeEntry("ask_exit", "yes");
  else
    config->deleteEntry("ask_exit");

  config->sync();
  default_profile_widget->saveDefaultProfile();

  close();
}

void KompileSetupDialog::writeServiceMenu(bool standalone)
{

  QStringList list = KGlobal::dirs()->resourceDirs("appdata");
  for (QStringList::Iterator dir = list.begin(); dir != list.end(); ++dir)
  {
    QDir directory(*dir);
    directory.cdUp();
    directory.cd("konqueror/servicemenus/");

    QString file_name(directory.absPath() + "/kompile-servicemenu.desktop");
    QFileInfo file(file_name);
    if (!file.exists() || !file.isWritable())
    {
      continue;
    }

    KConfig * menu = new KConfig(file_name);

    menu->setGroup("Desktop Entry");
    menu->writeEntry("Version", "0.3");
    menu->writeEntry("Type", "Application");
    menu->writeEntry("Encoding", "UTF-8");
    menu->writeEntry("Name", "Kompile");
    menu->writeEntry("Comment", "kde service menu for automated install of sources tarball packages");
    menu->writeEntry("ServiceTypes", "application/x-tgz,application/x-tbz,application/x-tar,application/x-tarz");
    menu->writeEntry("Actions", "default_install;profiled_install;default_uninstall;profiled_uninstall;");

    if (standalone)
    {
      menu->writeEntry("Icon", "kpackage");
      menu->writeEntry("X-KDE-Submenu", "Kompile Tarball Installer");
      menu->writeEntry("X-KDE-Submenu[it]", "Kompile Installer per Tarball");
      menu->writeEntry("X-KDE-Priority", "TopLevel");
      menu->writeEntry("X-KDE-Icon", "tgz");
    }
    else
    {
      menu->deleteEntry("Icon");
      menu->deleteEntry("X-KDE-Submenu");
      menu->deleteEntry("X-KDE-Submenu[it]");
      menu->deleteEntry("X-KDE-Priority");
      menu->deleteEntry("X-KDE-Icon");
    }

    menu->setGroup("Desktop Action default_install");
    menu->writeEntry("Name", "Perform default package installation");
    menu->writeEntry("Name[it]", "Installazione predefinita del pacchetto");
    menu->writeEntry("Icon", "kpackage");
    menu->writeEntry("Exec", "kompile --install --use-tarball %U");

    menu->setGroup("Desktop Action profiled_install");
    menu->writeEntry("Name", "Search copatible profile for installation");
    menu->writeEntry("Name[it]", "Cerca un profilo compatibile per l'installazione");
    menu->writeEntry("Icon", "tar");
    menu->writeEntry("Exec", "kompile --install --search-profile --use-tarball %U");

    menu->setGroup("Desktop Action default_uninstall");
    menu->writeEntry("Name", "Perform default package uninstallation");
    menu->writeEntry("Name[it]", "Disinstallazione predefinita del pacchetto");
    menu->writeEntry("Icon", "trashcan_full");
    menu->writeEntry("Exec", "kompile --uninstall --use-tarball %U");

    menu->setGroup("Desktop Action profiled_uninstall");
    menu->writeEntry("Name", "Search copatible profile for uninstallation");
    menu->writeEntry("Name[it]", "Cerca un profilo compatibile per la disinstallazione");
    menu->writeEntry("Icon", "editdelete");
    menu->writeEntry("Exec", "kompile --uninstall --search-profile --use-tarball %U");
    menu->sync();
  }
}
