/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* renderimage.h
 */
#ifndef renderimage_h
#define renderimage_h

#include <qimage.h>


/** A QImage derived class that is designed for drawing 32bit images.
 */
class RenderImage: public QImage
{
   typedef QImage Inherited;

public:
   RenderImage();
   RenderImage(int w, int h);
   RenderImage(const RenderImage&);
   explicit RenderImage(const QImage&);
   virtual ~RenderImage();
   RenderImage& operator=(const RenderImage&);
   RenderImage& operator=(const QImage&);

   /** Merge image img into this image at position (x,y). If sx,sy,sw,sh are
    * specified, only a part of img is merged.
    */
    void setImage(int x, int y, const QImage& img, int sx=0, int sy=0,
                  int sw=-1, int sh=-1);

   /** Set all pixel that have all color values smaller than limit to pixClear,
    * all other pixels (with higher color value) to pixSet.
    */
   void threshold(int limit, QRgb pixClear, QRgb pixSet);

private:
   static void initAlphaTab();
};

#endif /*renderimage_h*/
