/***************************************************************************
                          mystatusbar.cpp  -  description
                             -------------------
    begin                : Tue Sep 12 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mystatusbar.h"
#include <qtooltip.h>
#include <kdebug.h>
#include <kstatusbar.h>
#include <kconfig.h>
#include <kglobal.h>

// $Id: mystatusbar.cpp,v 1.3 2003/08/21 09:32:39 lx2gt Exp $

#define FONT_Y_DELTA 3
#define DEFAULT_BORDERWIDTH 0

/*myStatusBar::myStatusBar(QWidget *parent, const char *name ) : QStatusBar(parent,name)
{
}

myStatusBar::~myStatusBar()
{
} */


myStatusBar::myStatusBar( QWidget *parent, const char *name )
  : QStatusBar( parent, name )
{
  items.setAutoDelete(false);

  KConfig *config = KGlobal::config();
  QString group(config->group());
  config->setGroup(QString::fromLatin1("StatusBar style"));
  bool grip_enabled = config->readBoolEntry(QString::fromLatin1("SizeGripEnabled"), false);
  setSizeGripEnabled(grip_enabled);
  config->setGroup(group);

}

myStatusBar::~myStatusBar ()
{
  // Umm... delete something;
  items.clear();
}

void myStatusBar::insertItem( const QString& text, int id, int stretch, bool permanent)
{
  KStatusBarLabel *l = new KStatusBarLabel (text, id, (KStatusBar*)this);
  items.insert(id, l);
	//l->setFrameStyle (QFrame::Raised);
  addWidget (l, stretch, permanent);
}

void myStatusBar::removeItem (int id)
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    removeWidget (l);
    items.remove(id);
    // reformat (); // needed? (sven)
  }
  else
    kdDebug() << "KStatusBar::removeItem: bad item id: " << id << endl;
}

void myStatusBar::changeItem( const QString& text, int id )
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    clear();
    l->setText(text);
    reformat();
  }
  else
    kdDebug() << "KStatusBar::changeItem: bad item id: " << id << endl;
}

void myStatusBar::setItemAlignment (int id, int align)
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
    //clear();
    l->setAlignment(align);
    //reformat(); Not needed I, think (sven)
  }
  else
    kdDebug() << "KStatusBar::setItemAlignment: bad item id: " << id << endl;
}

void myStatusBar::setItemFixed(int id, int w)
{
   KStatusBarLabel *l = items[id];
  if (l)
  {
    if (w==-1)
      w=fontMetrics().boundingRect(l->text()).width()+3;

    l->setFixedSize(w, l->sizeHint().height());
  }
  else
    kdDebug() << "KStatusBar::setItemFixed: bad item id: " << id << endl;
}

void myStatusBar::slotPressed(int _id)
{
  emit pressed(_id);
}

void myStatusBar::slotReleased(int _id)
{
  emit released(_id);
}


void myStatusBar::setToolTip (int id, QString str)
{
  KStatusBarLabel *l = items[id];
  if (l)
  {
		QToolTip::add (l, str);
  }
  else
    kdDebug() << "KStatusBar::setToolTip: bad item id: " << id << endl;

}
