/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDZIPCODE_H_
#define _KKDZIPCODE_H_

#include "kkdtextbase.h"

namespace KKDesigner
{
	/**
	 * @english
	 * Item for Zipcode
	 * Draw zipcode with auto layout
	 *
	 * @author SUZUKI Tasuku
	 * @endenglish
	 * @japanese
	 * 郵便番号アイテム
	 * 自動でレイアウトする郵便番号用のクラス
	 *
	 * @author 鈴木　佑
	 * @endjapanese
	 */
	class KKDZipcode : public KKDTextBase
	{
		Q_OBJECT
	public:
		KKDZipcode( const QPoint& l
				  , const QSize& s
				  , const QFont& f
				  , const QColor& c
				  , Orientation o
				  , QObject* parent = 0
				  );
		KKDZipcode( QDomElement e, QObject* parent = 0 );
		KKDZipcode( const KKDZipcode* item, QObject* parent = 0 );
		~KKDZipcode();

		static const QString tagName(){ return QString( "Zipcode" ); }
		QDomElement toElement( QDomDocument& doc, const QString& t = QString::null );

		//BEGIN Properties
		virtual ItemType type() const { return Zipcode; }
		//END   Properties

	protected:
		virtual void drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d = 0 );
		virtual void drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d = 0 );

	private:
		void drawTextJP( QRect& r, QPainter& p, const KKAddressBook::KKAContactData* d );
	};
}

#endif /* _KKDZIPCODE_H_ */
