/***************************************************************************
                          datetime.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATETIME_H
#define DATETIME_H

/*
 * This two includes are required, because you have to use
 * KRenames internal structures and enums.
 */
#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

#include <stdio.h>

class KDatePicker;
class KIntSpinBox;
class QCheckBox;
class QButtonGroup;
class QGroupBox;
class QLabel;
class QVBoxLayout;
class QHBoxLayout;
class QPushButton;
class QString;
class QWidget;

class MyDatePlugin: public Plugin {
    Q_OBJECT
    public:
        const QString getName() const;
        const QString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( QWidget* w, QVBoxLayout* l );
        void fillStructure();
        QString processFile( BatchRenamer*, int, QString token, int );

        const QPixmap getIcon() const;
                        
    private slots:
        void changeDT();

    protected:
        QCheckBox* checkAccess;
        QCheckBox* checkModification;
        KDatePicker* kDate;
        QLabel* labelTime;
        KIntSpinBox* spinHour;
        KIntSpinBox* spinMinute;
        KIntSpinBox* spinSecond;
        QPushButton* buttonCurrentDT;

        QHBoxLayout* Layout0;
        QVBoxLayout* Layout1;
        QHBoxLayout* Layout2;

        struct datevals {
            QDate date;                 // Date

            bool changeModification;    // Change modification date
            bool changeAccess;          // Change access date

            int hour;
            int minute;
            int second;
        } dvals;
};


#endif


