/***************************************************************************
                  dsdirselectdialog.cpp  -  description
                             -------------------
    begin                : Sat Jan 03 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dsdirselectdialog.h"

// Qt includes
#include <qcheckbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qvbox.h>

// KDE includes
#include <kdiroperator.h> 
#include <klocale.h>
#include <kurlcombobox.h> 

DSDirSelectDialog::DSDirSelectDialog( QWidget* parent )
        : KFileDialog( ":KRename", "*", parent, 0, false ) 
{
    setOperationMode( KFileDialog::Opening );
    setMode( KFile::Files | KFile::ExistingOnly );
    
    QVBox* vbox = new QVBox( this );

    if( layout() )
        layout()->add( vbox );
    else
        qDebug("KFileDialog does not have a layout!!!");

    checkDir = new QCheckBox( i18n("Add directory names &with filenames"), vbox );
    check = new QCheckBox( i18n("Add subdirectories &recursively"), vbox );
    QHBox* hbox = new QHBox( vbox );
    QWidget* spacer = new QWidget( hbox );
    spacer->setMinimumWidth( 20 );
    checkHidden = new QCheckBox( i18n("Add &hidden directories"), hbox );
    hbox->setStretchFactor( checkHidden, 4 );
    checkOnlyDir = new QCheckBox( i18n("Add directory names only"), vbox );    
    connect( check, SIGNAL( clicked() ), this, SLOT( enableControls() ));

    QToolTip::add( check, i18n("Walk recursively through the directory tree and add also the content of all subdirectories to the list of files to rename.") );
    QToolTip::add( checkHidden, i18n("If not checked, KRename will ignore directories starting with a dot during recursive adding.") );
    QToolTip::add( checkOnlyDir, i18n("Add only the directory names and not the names of the files in the directory to KRename.") );
    QToolTip::add( checkDir, i18n("This option causes KRename to add also the name of the base directory of the selected files to its list.") );
    
    enableControls();
}

bool DSDirSelectDialog::recursively() const
{
    return check->isChecked();
}

bool DSDirSelectDialog::hidden() const
{
    return checkHidden->isChecked();
}

bool DSDirSelectDialog::dirs() const
{
    return checkDir->isChecked();
}

bool DSDirSelectDialog::onlyDirs() const
{
    return checkOnlyDir->isChecked();
}

void DSDirSelectDialog::setRecursively( bool b )
{
    check->setChecked( b );
}

void DSDirSelectDialog::enableControls()
{
    checkHidden->setEnabled( check->isChecked() );
}

void DSDirSelectDialog::slotOk()
{
    const KFileItemList *items = ops->selectedItems();
    if ( !items || items->isEmpty() )
    {
        KDialogBase::accept();
    } else  
        KFileDialog::slotOk();
}

KURL::List DSDirSelectDialog::selectedURLs()
{
    KURL::List list = KFileDialog::selectedURLs();
    if( list.isEmpty() )
        list.append( baseURL() ); 
        
    return list;
}
#include "dsdirselectdialog.moc"
