/***************************************************************************
                          permission.h  -  description
                             -------------------
    begin                : Sun Jan 13 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PERMISSION_H
#define PERMISSION_H

/*
 * This two includes are required, because you have to use
 * krenames internal structures and enums.
 */
#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

#include <stdio.h>

class KComboBox;
class QCheckBox;
class QGroupBox;
class QVBoxLayout;
class QHBoxLayout;
class QString;
class QWidget;


// Plugin class starts here
class MyPermPlugin: public Plugin {
    Q_OBJECT
    public:
        const QString getName() const;
        const QString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( QWidget* w, QVBoxLayout* l );
        void fillStructure();
        QString processFile( BatchRenamer* b, int, QString token, int );
        void finished();
        const QPixmap getIcon() const;        

    private:
        int getPermissions();
        int getGid( QString group );
        int getUid( QString owner );

        struct pervals {
            bool changePermissions;
            bool changeOwner;

            QString owner;  // name of owner
            QString group;  // name of group

            int newPermission;  // Permissions
        }perm;

    private slots:
        void enableControls();

    protected:
        QGroupBox* groupPermission;
        QGroupBox* groupOwner;
        QCheckBox* checkPermissions;
        QCheckBox* checkOwner;
        QCheckBox* permBox[3][4];
        KComboBox* username;
        KComboBox* groupname;

        QVBoxLayout* groupOwnerLayout;
        QVBoxLayout* Layout0;
        QHBoxLayout* Layout2;
        QHBoxLayout* Layout3;
        QHBoxLayout* Layout4;
};

#endif
