/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>

#include <kuniqueapp.h>
#include <dcopclient.h>

#include <kiconloader.h>
#include <kdialogbase.h>
#include <klocale.h>
#include <kprocess.h>
#include <kdebug.h>

#include "ksnifferoptiondialog.h"
#include "snifferoptiontab.h"

KSnifferOptionDialog::KSnifferOptionDialog( QWidget *parent, const char *name, bool modal )
  : KDialogBase( IconList, i18n("Configuration"), Apply|Ok|Cancel, Ok, parent, name, modal, true)
{
  // this is the base class for your preferences dialog.  it is now
  // a Treelist dialog, but there are a number of other
  // possibilities (including Tab, Swallow, and just Plain)

  setupSnifferPage();

/*
  QFrame *frame = addPage(i18n("Misc"), i18n("Miscellaneous Settings"),
    KGlobal::instance()->iconLoader()->loadIcon( "misc", KIcon::NoGroup, KIcon::SizeMedium ));
    */

/*
  frame = addPage( i18n("Notifications"), i18n("System Notifications"),
    KGlobal::instance()->iconLoader()->loadIcon( "knotify", KIcon::NoGroup, KIcon::SizeMedium ) );

  frame = addPage( i18n("Programs"), i18n("Setup External Programs"),
    KGlobal::instance()->iconLoader()->loadIcon( "exec", KIcon::NoGroup, KIcon::SizeMedium ) );
*/

  // read the pages settings
  m_snifferOptionTab->readSettings();

  resize( 700, 500 );
  showPage( 0 );
}


KSnifferOptionDialog::~KSnifferOptionDialog()
{
}


void KSnifferOptionDialog::slotOk()
{
  if( saveSettings() )
    accept();
}


void KSnifferOptionDialog::slotApply()
{
  saveSettings();
}


bool KSnifferOptionDialog::saveSettings()
{
  // save all the configuration
  if( !m_snifferOptionTab->saveSettings() )
    return false;

  return true;
}


void KSnifferOptionDialog::setupSnifferPage()
{
  QFrame *frame = addPage( i18n("Capture"), i18n("Capture Settings"),
    KGlobal::instance()->iconLoader()->loadIcon( "ksniffer", KIcon::NoGroup, KIcon::SizeMedium ) );

  QVBoxLayout* box = new QVBoxLayout( frame, 0, 0, "snifferpage" );

  m_snifferOptionTab = new SnifferOptionTab( frame );
  box->addWidget( m_snifferOptionTab );
  connect( m_snifferOptionTab, SIGNAL( trayBarShown( bool ) ), this, SIGNAL( trayBarShown( bool ) ) );
}

#include "ksnifferoptiondialog.moc"
