/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <stdlib.h>
#include <netinet/in.h>

#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>
//#include <kdebug.h>

#include "ip-protocol.h"
#include "../packet.h"
#include "../packetstructures.h"

IpProtocol::IpProtocol(Packet *packet)
{
/*
  m_packet = packet;
  m_length = packet->frameHeaderLength();
  */
  init(packet);
}


IpProtocol::IpProtocol(Packet *packet, int length)
{
/*
  m_packet = packet;
  m_length = length;
*/
  init(packet, length);
}


IpProtocol::IpProtocol(ptrPacketType packet)
{
/*
  m_packet = (Packet *)packet;
  m_length = m_packet->frameHeaderLength();
*/
  init((Packet *)packet);
}


IpProtocol::IpProtocol(ptrPacketType packet, int length)
{
/*
  m_packet = (Packet *)packet;
  m_length = length;
*/
  init((Packet *)packet, length);
}


void IpProtocol::init(Packet *packet, int length)
{
  m_packet = packet;
  m_length = length != -1 ? length : packet->frameHeaderLength();
}


u_int8_t IpProtocol::version() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ( (u_int8_t) ip->version );
}


int IpProtocol::headerLength() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return (ip->ihl << 2);
}


u_int16_t IpProtocol::totalLength() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ntohs(ip->tot_len);
}


u_int16_t IpProtocol::id() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ntohs(ip->id);
}


QString IpProtocol::flagR() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  u_int16_t frag_off = ntohs(ip->frag_off);
  QString ret;

  if ( frag_off & (1 << 13) )
    ret = i18n("Set");
  else
    ret = i18n("Not set");

  return ret;
}


QString IpProtocol::flagDF() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  u_int16_t frag_off = ntohs(ip->frag_off);
  QString ret;

  if ( frag_off & (1 << 14) )
    ret = i18n("Set");
  else
    ret = i18n("Not set");

  return ret;
}


QString IpProtocol::flagMF() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  u_int16_t frag_off = ntohs(ip->frag_off);
  QString ret;

  if ( frag_off & (1 << 15) )
    ret = i18n("Set");
  else
    ret = i18n("Not set");

  return ret;
}


u_int16_t IpProtocol::fragmentOffset() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ( ntohs(ip->frag_off) & 8191 );  // 8191 is 00011111 11111111 in binary
}


u_int8_t IpProtocol::ttl() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ( (u_int8_t) ip->ttl );
}


u_int8_t IpProtocol::protocol() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ( (u_int8_t) ip->protocol );
}


QString IpProtocol::strProtocol() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );
  QString proto;

  switch ( (u_int8_t) ip->protocol )
  {
    case 1:
      proto = "ICMP";
      break;
    case 6:
      proto = "TCP";
      break;
    case 17:
      proto = "UDP";
      break;
  }

  return proto;
}

u_int16_t IpProtocol::checksum() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );

  return ntohs(ip->check);
}


QString IpProtocol::sourceAddress() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );
  unsigned char *x = (unsigned char *) (&ip->saddr);

  return QString("%1.%2.%3.%4").arg(x[0]).arg(x[1]).arg(x[2]).arg(x[3]);
}


QString IpProtocol::destinationAddress() const
{
  struct IpHdr *ip = (struct IpHdr*) ( (ptrPacketType)m_packet + m_length );
  unsigned char *x = (unsigned char *) (&ip->daddr);

  return QString("%1.%2.%3.%4").arg(x[0]).arg(x[1]).arg(x[2]).arg(x[3]);
}


QString IpProtocol::strInfo() const
{
  return "IP packet information";
}


QStringList IpProtocol::headerLines() const
{
  QStringList list;

  list << i18n("IP protocol field", "Version: %1").arg( version() );
  list << i18n("IP protocol field", "Header length: %1").arg( headerLength() );
  list << i18n("IP protocol field", "Total length: %1").arg( totalLength() );
  list << i18n("IP protocol field", "Identification: 0x%1 (%2)").arg( id(), 0, 16 ).arg( id() );
  list << "*open";
  list << i18n("IP protocol field: flags", "Flags:");
  list << i18n("IP protocol field: flags (R)", "Reserved bit: %1").arg( flagR() );
  list << i18n("IP protocol field: flags (DF)", "Don't fragment: %1").arg( flagDF() );
  list << i18n("IP protocol field: flags (MF)", "More fragments: %1").arg( flagMF() );
  list << "*close";
  list << i18n("IP protocol field", "Fragment offset: %1").arg( fragmentOffset() );
  list << i18n("IP protocol field", "Time to live: %1").arg( ttl() );
  list << i18n("IP protocol field", "Protocol: %1 (0x%2)").arg( strProtocol() ).arg( protocol(), 0, 16 );
  list << i18n("IP protocol field", "Header checksum: 0x%1").arg( checksum(), 0, 16 );
  list << i18n("IP protocol field", "Source address: %1").arg( sourceAddress() );
  list << i18n("IP protocol field", "Destination address: %1").arg( destinationAddress() );

  return list;
}
