/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kdebug.h>

#include "protocolname.h"

ProtocolName::ProtocolName()
{
  m_protocolName = QString::null;
  parseServicesFile();
}


ProtocolName::~ProtocolName()
{
}


QString ProtocolName::detectProtocol( uint16_t const& proto )
{
  switch (proto)
  {
    case 21:
      return "ftp";
    case 25:
      return "smtp";
    case 80:
      return "http";
    case 110:
      return "pop3";
    case 143:
      return "imap";
    case 389:
      return "ldap";
    case 554:
      return "rtsp";
    default:
      return QString::null;
  }
}


void ProtocolName::parseServicesFile()
{
  QString filename = "/etc/services";
  QFile file( filename );

  if ( file.open( IO_ReadOnly ) )
  {
    QTextStream stream( &file );
    QString line;
    int index = 0;

    while ( !stream.atEnd() )
    {
      line = stream.readLine(); // line of text excluding '\n'
      int j = 0;
      while ( line.at( j ) == ' ' )
        j++;
      if ( (line.at( j ) != '#') && (line.length() > 0))
      {
        QString token, port;
        short tcp_udp = 0;

        while ( (line.at( j ) != ' ') && (line.at( j ).unicode() != 9) )
          // 9 is unicode for TAB character
          token.append( line.at( j++ ) );
        while ( !line.at( j ).isDigit() )
          j++;
        while ( line.at( j ).isDigit() )
          port.append( line.at( j++ ) );
        j++;
        if ( line.mid( j, 3 ) == "tcp" )
          tcp_udp = TCP_NUM;
        else if ( line.mid( j, 3 ) == "udp" )
          tcp_udp = UDP_NUM;
        if ( index > 0 )
          if ( ports[index - 1].port == port.toInt() )
          {
            index--;
            ports[index].tcp_udp |= tcp_udp;  // add the second protocol (UDP or TCP)
          }
          else
          {
            ports[index].name = token;
            ports[index].port = port.toInt();
            ports[index].tcp_udp = tcp_udp;
          }
      }
      index++;
    }
    file.close();
  }
}


int ProtocolName::isTCP( uint16_t const& proto )
{
  int i = 0;

  while ( (i < PROTO_NUM) && (ports[i].port != proto) )
    i++;

  if (ports[i].port != proto)
    // port not found
    return -1;
  else
    return ( (ports[i].tcp_udp & TCP_NUM) == TCP_NUM );
}


int ProtocolName::isUDP( uint16_t const& proto )
{
  int i = 0;

  while ( (i < PROTO_NUM) && (ports[i].port != proto) )
    i++;

  if (ports[i].port != proto)
    // port not found
    return -1;
  else
    return ( (ports[i].tcp_udp & UDP_NUM) == UDP_NUM );
}
