/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef PROTOCOLNAME_H
#define PROTOCOLNAME_H

#define PROTO_NUM 49151
#define TCP_NUM 1
#define UDP_NUM 2

#include <netinet/in.h>

#include <qstring.h>

/**
@author Giovanni Venturi
*/

struct Name_Port
{
  QString name;
  int port;
  short tcp_udp;  // TCP_NUM: 1 -> tcp, UDP_NUM: 2 -> udp
};

class ProtocolName
{
  public:
    ProtocolName();
    ~ProtocolName();

    static QString detectProtocol( uint16_t const& proto );
    int isTCP( uint16_t const& proto );
    int isUDP( uint16_t const& proto );

  private:
    QString m_protocolName;
    Name_Port ports[PROTO_NUM];

    void parseServicesFile();
};

#endif
