/***************************************************************************
 *   Copyright (C) 2003-2005 by Michael Goettsche                          *
 *   mail@tuxipuxi.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KSTREAMRIPPER_H
#define KSTREAMRIPPER_H

#include <kdeversion.h>
#include "kstreamripperbase.h"
#if KDE_IS_VERSION(3,3,90)
#include <dnssd/servicebrowser.h>
#include <dnssd/remoteservice.h>
#else
// damned moc will create slots regardless of #if macro
// this is hack to avoid undefined type
namespace  DNSSD { namespace RemoteService { typedef int Ptr; } } 
#endif


class AddNewStreamImpl;
class QString;

class KStreamRipper : public KStreamRipperBase
{
    Q_OBJECT

public:
 
    KStreamRipper( QWidget* parent = 0, const char* name = 0 );
    ~KStreamRipper();

    virtual void closeEvent( QCloseEvent* );
#if KDE_IS_VERSION(3,3,90)
    DNSSD::ServiceBrowser m_browser;	
#endif

protected slots:

    void addStreamButtonClicked();
    void deleteStreamButtonClicked();
    void tuneInButtonClicked();
    void ripButtonClicked();
    void stopRipButtonClicked();
    void browseButtonClicked();
    void aboutButtonClicked();
    void quitButtonClicked();
    
    void selectedNewListItem();
    void descriptionChanged();
    void urlChanged();
	
    void addStreamFinished( AddNewStreamImpl* );
#if KDE_IS_VERSION(3,3,90)
    void serviceAdded(DNSSD::RemoteService::Ptr srv);
    void serviceRemoved(DNSSD::RemoteService::Ptr srv);
#else
    void serviceAdded(DNSSD::RemoteService::Ptr) {};
    void serviceRemoved(DNSSD::RemoteService::Ptr) {};
#endif
};

#endif

