#ifndef GLWINDOW_H
#define GLWINDOW_H

#include <qgl.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qimage.h>
#include "sudoku_solver.h"
#include "ArcBall.h"

class ksudoku;
/**
@author Francesco Rossi
*/
class glWindow : public QGLWidget
{
Q_OBJECT
public:
    glWindow(QWidget *parent = 0, const char *name = 0, int order=9, int difficulty=1, int simmetry=0, bool dub=0);
    ~glWindow();
public:
	skPuzzle* puzzle;
	skPuzzle* completed_puzzle;
	skPuzzle stack[126];
	int stack_d;
	skSolver* mySolver;
	int base;
	int order;
	int size;
//	int remaining;
	char selected_number;

	bool isClicked;
	bool isRClicked;	
	bool isDragging;	
	ArcBallT*    ArcBall;	
	int selection;

	float dist;
	float wheelmove;

	//bool guidedMode;
	bool selected[125][4]; //2FIX memory and dealloc
	//int values[64];
	int flags [125];

	GLuint  texture[2][26];
public:
	void push();
	void pop();
	int genPuzzle(bool dub);
public:
    void paintGL();
	void initializeGL();

	void resizeGL( int w, int h )
	{
		if(w==0)w=1;	
		if(h==0)h=1;
		ArcBall = new ArcBallT((GLfloat)w,(GLfloat)h);

        glViewport( 0, 0, (GLint)w, (GLint)h );
		glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
		glLoadIdentity();							// Reset The Projection Matrix

		gluPerspective(45.0f,(GLfloat)w/(GLfloat)h,0.1f,100.0f);

		glMatrixMode(GL_MODELVIEW);						// Select The Modelview Matrix
		glLoadIdentity();			
    }
protected:
	void Selection(int mouse_x, int mouse_y);
	void mouseReleaseEvent ( QMouseEvent * e )
	{
		if(e->button() == Qt::LeftButton) isClicked = false;
	}
	void mousePressEvent ( QMouseEvent * e )
	{
		if(e->button() == Qt::LeftButton) isClicked = true;
	}	
protected:
	void myDrawCube(int n, GLfloat x, GLfloat y, GLfloat z, int texture);
	void mouseMoveEvent ( QMouseEvent * e ) ;
	void keyReleaseEvent ( QKeyEvent * e );

	void mouseDoubleClickEvent ( QMouseEvent * e );
	void wheelEvent ( QWheelEvent * e ) 
	{
		wheelmove += e->delta() * .02;
		paintGL();
	}

	//ACTIONS
public:
	void giveHint();
	void autoSolve()
	{
			//m_view->mySolver->solve(m_view->puzzle, 1, m_view->puzzle);
		ITERATE(i,puzzle->size)
		{
			puzzle->numbers[i] = completed_puzzle->numbers[i];
			flags[i]  = 1;
		}
		paintGL();
	}
};

#endif
