/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktranslatordock.h"
#include <kapplication.h>
#include <kaction.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif



ktranslatorDock::ktranslatorDock( QWidget *parent, const char *name )
 : KSystemTray( parent, name )
{
#ifndef NDEBUG

  kdDebug() << "ktranslatorDock::ktranslatorDock()" << endl;

#endif

  connect( this, SIGNAL( quitSelected() ), kapp, SLOT( quit() ));
}


ktranslatorDock::~ktranslatorDock()
{
}

void ktranslatorDock::mousePressEvent( QMouseEvent *e )
{
#ifndef NDEBUG

  kdDebug() << "ktranslatorDock::mousePressEvent()" << endl;

#endif

  if( e->button() == Qt::MidButton )
  {
    actionCollection()->action( "watchAction" )->activate();
    return;
  }
  KSystemTray::mousePressEvent( e );
}

