/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "stardictplugin.h"
#include "stardict.h"

#include <kgenericfactory.h>

#include <qfile.h>
#include <qregexp.h>
#include <qlabel.h>

#include <kprocio.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif


K_EXPORT_COMPONENT_FACTORY( ktranslator_stardict,
                            KGenericFactory<StarDictPlugin>( "ktranslator_stardict" ) )

StarDictPlugin::StarDictPlugin( QObject *parent, const char*, const QStringList &args )
            : KTranslator::DictionaryPlugin(parent, "StarDict" )
{
   KLocale::setMainCatalogue("ktranslator");
   dic = new StarDict( args[0] );
   dictName = args[1];
   setOk( dic->isOk() );
   setEnabled( true );
   m_tooltip = i18n( "StarDict Dictionary\nBookname: %1\nAuthor: %2\nVersion: %3\nDescription: %4\nWords: %5" ).arg( dic->bookname() ).arg( dic->author() ).arg( dic->version() ).arg( dic->description() ).arg( dic->size() );
}

QString StarDictPlugin::search( const QString &word )
{

  #ifndef NDEBUG

  kdDebug() << "StarDict Plugin search()" << endl;

  #endif

  QString result = dic->search( word );

  if( result.isEmpty() ) return QString ( "<dicName>%1</dicName><font color=#000000>%2</font>" ).arg( dictName ).arg( i18n( "Word not found" ) );

  result = result.stripWhiteSpace().replace( '\n', "<br>" );
  return QString( "<dicName>%1</dicName><definition>%3</definition>" ).arg( dictName ).arg( result );
}


QWidget *StarDictPlugin::confPage()
{
  return new QLabel( "This plugin has no configurations", 0 );
}


void StarDictPlugin::applyConf( QWidget * )
{
  return;
}


int StarDictPlugin::size()
{
  return dic->size();
}
