/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "resultswindow.h"
#include "ktranslator.h"

#include "config.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qcursor.h>
#include <qtooltip.h>
//#include <qwhatsthis.h>
#include <qevent.h>
#include <qpoint.h>
#include <qtimer.h>
#include <qfont.h>

#include <klocale.h>
#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>

resultsWindow::resultsWindow( const QString &text, ktranslator *parent, const char* name )
 : QFrame( 0, name, Qt::WStyle_Customize | Qt::WDestructiveClose | Qt::WX11BypassWM | Qt::WStyle_StaysOnTop | Qt::WStyle_Tool | Qt::WStyle_NoBorder )
{
  setFrameStyle( QFrame::Box| QFrame::Plain );
  setLineWidth( 3 );

  QGridLayout *box = new QGridLayout( this, 1, 1, 11, 6, "Form1Layout");
  KIconLoader *icon = new KIconLoader();

  // Widget for the result text
  textbrowser = new QTextBrowser( this );
  textbrowser->setText( text );
  textbrowser->setFont( config::resultFont() );
  textbrowser->setPaletteBackgroundColor( config::backgroundColor() );
  textbrowser->setTextFormat( RichText );
  //textbrowser->setFixedSize( 320, 200 );
  box->addMultiCellWidget( textbrowser, 0, 3, 0, 0 );
  connect( textbrowser, SIGNAL( linkClicked( const QString & ) ), this, SLOT( linkClicked( const QString & ) ) );

  // Button to close the window
  QPushButton *closeButton = new QPushButton( icon->loadIcon( "fileclose", KIcon::Small ), QString::null, this );
  closeButton->setFixedSize( 25, 25 );
  box->addWidget( closeButton, 0, 1 );
  QToolTip::add( closeButton, i18n( "Close" ) );
  //QWhatsThis::add( closeButton, i18n( "Closes the window" ) );
  connect( closeButton, SIGNAL( clicked() ), this, SLOT( close() ) );

  // Button to search the word in some sites
  QPushButton *searchButton = new QPushButton( icon->loadIcon( "konqueror", KIcon::Small ), QString::null, this );
  searchButton->setFixedSize( 25, 25 );
  box->addWidget( searchButton, 2, 1 );
  QToolTip::add( searchButton, i18n( "Search in Internet" ) );
  //QWhatsThis::add( searchButton, i18n( "Search the word in some sites from Internet" ) );
  connect( searchButton, SIGNAL( clicked() ), parent, SLOT( searchInInternet() ) );
  connect( searchButton, SIGNAL( clicked() ), this, SLOT( close() ) );

  // Button to speech the word
  QPushButton *speechButton = new QPushButton( icon->loadIcon( "arts", KIcon::Small ), QString::null, this );
  speechButton->setFixedSize( 25, 25 );
  box->addWidget( speechButton, 1, 1 );
  QToolTip::add( speechButton, i18n( "Speech the word" ) );
  //QWhatsThis::add( speechButton, i18n( "Speechs the word" ) );
  connect( speechButton, SIGNAL( clicked() ), parent, SLOT( speech() ) );

  QSpacerItem *spacer = new QSpacerItem( 20, 110, QSizePolicy::Minimum, QSizePolicy::Expanding );
  box->addItem( spacer, 3, 1 );
  /*if( mostrarBotoes )
  {
    (void) new QLabel( i18n( "<font color=%1>A palavra n� foi encontrada no dicion�io do Freedict.</font>" ).arg( Config().m_corDefinicao ), vb );
    QPushButton *botaoAcrescentar = new QPushButton( i18n( "Add Word" ), vb );
    botaoAcrescentar->setFixedSize( 160, 30 );
    connect( botaoAcrescentar, SIGNAL( clicked() ), parent, SLOT( acrescentarPalavra() ) );
  }*/

  // window colors
  setPaletteBackgroundColor( config::backgroundColor() );
  setPaletteForegroundColor( config::borderColor() );

  resize( QSize( 360, 200 ) );
  this->parent = parent;
  oldX = oldY = 0;
  setFocusPolicy( QWidget::StrongFocus );

  if( config::hasResultTimeout() ) QTimer::singleShot( config::resultTimeout() * 1000, this, SLOT( timeout() ) );
}


resultsWindow::~resultsWindow()
{
}

void resultsWindow::focusOutEvent( QFocusEvent * )
{
  //close();
}

void resultsWindow::showEvent( QShowEvent * )
{
  resize( sizeHint() );
  // calculate the correct position of the window
  QPoint r = QCursor::pos();
  int desktopWidth = QApplication::desktop()->width();
  int widgetWidth = width();
  if( r.x() + widgetWidth > desktopWidth ) r.setX ( desktopWidth - widgetWidth - 30 );
  int widgetHeigth = height();
  if( r.y() - widgetHeigth < 0 ) r.setY( 10 );
  else r.setY( r.y() - widgetHeigth );
  move( r );
}


/*!
    \fn resultsWindow::linkClicked( const QString &link )
 */
void resultsWindow::linkClicked( const QString &link )
{
  textbrowser->clear();
  textbrowser->setText( parent->translate( link ) );
}


/*!
    \fn resultsWindow::mouseMoveEvent( QMouseEvent *e )
 */
void resultsWindow::mouseMoveEvent( QMouseEvent *e )
{
  int mouseX = e->globalX();
  int mouseY = e->globalY();

  int widgetX = x();
  int widgetY = y();

  int x = mouseX - oldX;
  int y = mouseY - oldY;

  oldX = mouseX;
  oldY = mouseY;

  x = widgetX + x;
  y = widgetY + y;

  move( x, y );
}


/*!
    \fn resultsWindow::mousePressEvent( QMouseEvent *e )
 */
void resultsWindow::mousePressEvent( QMouseEvent *e )
{
  oldX = e->globalX();
  oldY = e->globalY();
}


void resultsWindow::keyReleaseEvent( QKeyEvent *e )
{
  if ( e->key() == Key_Escape ) {
    e->accept();
    close();
  } else {
    e->ignore();
  }
}

void resultsWindow::timeout()
{
  close();
}

#include "resultswindow.moc"
