/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef NEWPROFILEDIALOG_H
#define NEWPROFILEDIALOG_H

#include "newprofiledialogbase.h"
#include "vpnaccountdata.h"
#include <qtextedit.h>
#include <kdialogbase.h>
#include <qobject.h>
#include <qptrlist.h>
#include "kvpncconfig.h"

/**
@author Christoph Thielecke
*/
class NewProfileDialog : public KDialogBase
{
	Q_OBJECT
public:
	NewProfileDialog( QApplication *app, QWidget *parent, const QString& caption, KVpncConfig *GlobalConfig);
	~NewProfileDialog();
	QString getName();
	

public slots:
	void accept();
	void reject();
	void importCertificate();
	void connectiontypeChanged( const QString& );
	void authTypeChanged( const QString& );
	void profileNameChanged(const QString&);
	void advancedSettingsClicked();
	void importPcfFileClicked();
  void groupPasswordContentChanged();
  void passwordContentChanged();

protected:
	NewProfileDialogbase *main;
	QString ConnectionType;
	QString Gateway;
	QString ID;
	QString Username;
	QString UserPassword;
	QString PreSharedKey;
	QString ApplicationVersion;
	QString NtDomainName;
	QString PerfectForwardSecrecy;
	QString IkeGroup;
	QString DnsServer; //< userdefined DNS server for pptp
	QString Name;
	QString Description;
	bool saveUserPassword;
	bool savePsk;
	bool useApplicationVersion;
	bool useGlobalIpsecSecret;
	bool useIkeGroup;
	bool useLocalPort;
	bool useNtDomainName;
	bool useSingleDes;
	bool useAdvancedSettings;
	bool usePerfectSecrecy;
	bool useUdp; //< True if NAT-T should be used
	bool useUdpPort; //< True if userdefined UDP port should be used
	bool useDnsServer; //< True if userdefined DNS server should be used
	bool useGetDnsFromPeer; //< True if DNS servers should be retrieved from peer (pptp)bool
	bool refuse40BitEncryption; //< True if 40 bit encryption is refused (pptp)
	bool refuse128BitEncryption; //< True if 128 bit encryption is refused (pptp)
	bool allowStatefulMode;
	bool useNoBsdComp;
	bool useNoDeflate;
	bool requireMppe; //< True if MPPE is required (pptp)
	bool refuseEap; //< True if EAP is refused (pptp)
	int Port;
	int UdpPort; //< Port number of UDP port
	KVpncConfig *GlobalConfig;


public:
	bool newProfileCreated;
	VpnAccountData *profileData;
};

#endif
