/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktrafficwidget.h"

KTrafficWidget::KTrafficWidget( int numValues, QWidget *parent, const char *name ) : QWidget( parent, name )
{
	this->numValues = numValues;
	values[0] = new long[ numValues ];
	values[1] = new long[ numValues ];
	clear();
	
	numLines = 8;
}


KTrafficWidget::~KTrafficWidget()
{
	delete [] values[ 0 ];
	delete [] values[ 1 ];
}

void KTrafficWidget::push( long sent, long recv )
{
	index++;
	if( index >= numValues )
	{
		index = 0;
	}
	values[SENT][index] = sent;
	values[RECV][index] = recv;
}

void KTrafficWidget::paintDiagramm()
{
	int tileWidth = width() / (numValues-2);
	int tileHeight = height() / numLines;
	QPainter painter(this);
		painter.setBackgroundColor( Qt::white );
		painter.setPen( Qt::black );
		
		painter.eraseRect( 0, 0, width()-1, height()-1 );
		
		painter.setPen( Qt::DashLine );
		
		int i;
		for( i=0; i<numLines; i++)
		{
			painter.drawLine( 0, i * tileHeight, width()-1, i * tileHeight );
		}
		
		painter.setPen( Qt::SolidLine );
		
		QFont font = painter.font();
		font.setPixelSize( tileHeight / 2 );
		painter.setFont( font );
		
		painter.drawLine( 0, 0, 0, height()-1 );
		painter.drawLine( width()-1, 0, width()-1, height()-1 );
		painter.drawLine( 0, height()-1, width()-1, height()-1 );
		
		if( isEnabled() )
		{
			int j = index;
			int prevJ = j-1;
			if( prevJ < 0 )
				prevJ = numValues - 1;
			for( i=0; i<numValues-1; i++ )
			{
				if( values[RECV][j] != -1 )
				{
					painter.setPen( Qt::red );
					painter.drawLine( width() - i*tileWidth, (int)(height() - (height()*(float)values[RECV][j]/(float)maxValue)),
						width() - (i+1)*tileWidth, (int)(height() - (height()*(float)values[RECV][prevJ]/(float)maxValue)) );
				}
				if( values[SENT][j] != -1 )
				{
					painter.setPen( Qt::blue );
					painter.drawLine( width() - i*tileWidth, (int)(height() - (height()*(float)values[SENT][j]/(float)maxValue)),
						width() - (i+1)*tileWidth, (int)(height() - (height()*(float)values[SENT][prevJ]/(float)maxValue) ));
				}
				j = prevJ;
				prevJ--;
				if( prevJ < 0 )
					prevJ = numValues - 1;
			}
		}
	
	painter.end();
}

/*!
    \fn KTrafficWidget::clear()
 */
void KTrafficWidget::clear()
{
	int i;
	for( i=0; i<numValues; i++)
	{
		values[0][i] = -1;
		values[1][i] = -1;
	}
	index = -1;
}


/*!
    \fn KTrafficWidget::paintEvent( QPaintEvent * )
 */
void KTrafficWidget::paintEvent( QPaintEvent * )
{
	paintDiagramm();
}


#include "ktrafficwidget.moc"
