/***************************************************************************
                          kentry.cpp  -  description
                             -------------------
    begin                : Fre Jan 31 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentry.h"

/*!
	\fn KWCEntry::KWCEntry( const QString & inscr, KSingleTabWidget *parent, const char *name )
 */
KWCEntry::KWCEntry( const QString & inscr, KSingleTabWidget *parent, const char *name ) : QObject( parent, name )
{
	this->parent = parent;
	
	valueWidget = NULL;
	value2Widget = NULL;
	rightWidget = NULL;

	inscriptionLabel = new QLabel( parent );
	setInscription( inscr );
}


/*!
	\fn KWCEntry::~KWCEntry()
 */
KWCEntry::~KWCEntry()
{
}


/*!
	\fn KWCEntry::setInscription( const QString & text )
 */
void KWCEntry::setInscription( const QString & text )
{
	inscriptionLabel->setText( text + ":" );
	inscriptionLabel->adjustSize();
}


/*!
	\fn KWCEntry::showValue( bool ok )
 */
void KWCEntry::showValue( bool ok )
{
	if( valueWidget != NULL )
		valueWidget->setShown( ok );
	if( rightWidget != NULL )
		rightWidget->setShown( ok );
	if( value2Widget != NULL )
		value2Widget->hide();
	inscriptionLabel->setEnabled( ok );
}


/*!
	\fn KWCEntry::showValue2( bool ok )
 */
void KWCEntry::showValue2( bool ok )
{
	if( valueWidget != NULL )
		valueWidget->hide();
	if( rightWidget != NULL )
		rightWidget->hide();
	if( value2Widget != NULL )
		value2Widget->setShown( ok );
	inscriptionLabel->setEnabled( ok );
}


/*!
	\fn KWCEntry::setValueWidget( QWidget *widget )
 */
void KWCEntry::setValueWidget( QWidget *widget )
{
	valueWidget = widget;
}


/*!
	\fn KWCEntry::setValue2Widget( QWidget *widget )
 */
void KWCEntry::setValue2Widget( QWidget *widget )
{
	value2Widget = widget;
}


/*!
	\fn KWCEntry::setRightWidget( QWidget *widget )
 */
void KWCEntry::setRightWidget( QWidget *widget )
{
	rightWidget = widget;
}


/*!
	\fn KWCEntry::getValueWidget()
 */
QWidget* KWCEntry::getValueWidget()
{
	return valueWidget;
}


/*!
	\fn KWCEntry::move( int row, int col, int alignment )
 */
void KWCEntry::move( int row, int col, int alignment )
{
	int labelCol = col * 5;
	int valueCol = labelCol + 2;
	
	parent->layout->addWidget( inscriptionLabel, row, labelCol, alignment );
	if( valueWidget != NULL )
	{
		parent->layout->addWidget( valueWidget, row, valueCol, alignment );
	}
	if( value2Widget != NULL )
	{
		parent->layout->addWidget( value2Widget, row, valueCol, alignment );
	}
	if( rightWidget != NULL )
	{
		parent->layout->addWidget( rightWidget, row, valueCol+1, alignment );
	}
}


/*!
	\fn KWCEntry::setWhatsThis( QString whatsThis )
 */
void KWCEntry::setWhatsThis( QString whatsThis )
{
	QWhatsThis::add( inscriptionLabel, whatsThis );
	if( valueWidget != NULL )
	{
		QWhatsThis::add( valueWidget, whatsThis );
	}
	if( value2Widget != NULL )
	{
		QWhatsThis::add( value2Widget, whatsThis );
	}
	if( rightWidget != NULL )
	{
		QWhatsThis::add( rightWidget, whatsThis );
	}

}
