/**************************************************************************
*   Copyright (C) 2006 by Remi Villatel <maxilys@tele2.fr>                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
**************************************************************************/

#include <kcolorbutton.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtoolbutton.h>
#include <qwhatsthis.h>

#include "serenityconfig.h"
#include "configdialog.h"

SerenityConfig::SerenityConfig(KConfig* config, QWidget* parent)
	: QObject(parent), m_config(0), m_dialog(0)
{
	// Create the configuration object.
	m_config = new KConfig("kwinserenityrc");
	KGlobal::locale()->insertCatalogue("kwin_serenity_config");
	
	// Create and show the configuration dialog.
	m_dialog = new ConfigDialog(parent);
	m_dialog->show();
	
	// Load the configuration.
	load(config);
	
	// Setup the connections.
	connect(m_dialog->m_titlePosition, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_useFrameColor, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_zenBorder, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_maxCorner, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_noMaxFrame, SIGNAL(toggled(bool)), this, SLOT(linkedChange()));
	//
	connect(m_dialog->m_titleSize, SIGNAL(valueChanged(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_buttonStyle, SIGNAL(activated(int)), this, SLOT(linkedChange()));
	connect(m_dialog->m_gradientType, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_alternateSinking, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_iconTheme, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_styledMenu, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_extraSpacing, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_centerTitle, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_noTitleFrame, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	
	connect(m_dialog->m_closerWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_menuWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_maxWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_minWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_stickyWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_aboveWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_belowWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
	connect(m_dialog->m_helpWide, SIGNAL(toggled(bool)), this, SIGNAL(changed()));

	connect(m_dialog->m_closerGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_menuGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_maxGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_minGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_stickyGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_aboveGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_belowGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	connect(m_dialog->m_helpGlow, SIGNAL(activated(int)), this, SIGNAL(changed()));
	
	connect(m_dialog->listColor0, SIGNAL(pressed()), this, SIGNAL(changed()));
	connect(m_dialog->listColor1, SIGNAL(pressed()), this, SIGNAL(changed()));
	connect(m_dialog->listColor2, SIGNAL(pressed()), this, SIGNAL(changed()));
	connect(m_dialog->listColor3, SIGNAL(pressed()), this, SIGNAL(changed()));
	connect(m_dialog->listColor4, SIGNAL(pressed()), this, SIGNAL(changed()));
	connect(m_dialog->listColor5, SIGNAL(pressed()), this, SIGNAL(changed()));
	connect(m_dialog->listColor6, SIGNAL(pressed()), this, SIGNAL(changed()));
	
	if ( m_dialog->m_noMaxFrame->isChecked() )
		m_dialog->m_maxCorner->setEnabled(false);
	else
		m_dialog->m_maxCorner->setEnabled(true);
	//
	if ( (m_dialog->m_buttonStyle->currentItem() == 1) 
	|| (m_dialog->m_buttonStyle->currentItem() == 7) )
	{
		m_dialog->m_noTitleFrame->setEnabled(false);
	}
	else
	{
		m_dialog->m_noTitleFrame->setEnabled(true);
	}
}

SerenityConfig::~SerenityConfig()
{
	if (m_dialog) delete m_dialog;
	if (m_config) delete m_config;
}

void SerenityConfig::load(KConfig*)
{
	m_config->setGroup("General");
	
	int titlePosition = m_config->readNumEntry("TitlePosition", 0);
	m_dialog->m_titlePosition->setCurrentItem(titlePosition);
	bool useFrameColor = m_config->readBoolEntry("UseFrameColor", false);
	m_dialog->m_useFrameColor->setChecked(useFrameColor);
	bool zenBorder = m_config->readBoolEntry("ZenBorder", false);
	m_dialog->m_zenBorder->setChecked(zenBorder);
	bool maxCorner = m_config->readBoolEntry("MaximizedCorner", true);
	m_dialog->m_maxCorner->setChecked(maxCorner);
	bool noMaxFrame = m_config->readBoolEntry("NoMaximizedFrame", false);
	m_dialog->m_noMaxFrame->setChecked(noMaxFrame);
	//
	int titleSize = m_config->readNumEntry("TitleSize", 20);
	m_dialog->m_titleSize->setValue(titleSize);
	int buttonStyle = m_config->readNumEntry("ButtonStyle", 0);
	m_dialog->m_buttonStyle->setCurrentItem(buttonStyle);
	int gradientType = m_config->readNumEntry("GradientStyle", 0);
	m_dialog->m_gradientType->setCurrentItem(gradientType);
	bool alternateSinking = m_config->readBoolEntry("AlternateSunkenEffect", false);
	m_dialog->m_alternateSinking->setChecked(alternateSinking);
	int iconTheme = m_config->readNumEntry("IconTheme", 0);
	m_dialog->m_iconTheme->setCurrentItem(iconTheme);
	bool styledMenu = m_config->readBoolEntry("StyledMenu", true);
	m_dialog->m_styledMenu->setChecked(styledMenu);
	bool extraSpacing = m_config->readBoolEntry("ExtraSpacing", false);
	m_dialog->m_extraSpacing->setChecked(extraSpacing);
	bool centerTitle = m_config->readBoolEntry("CenterTitle", true);
	m_dialog->m_centerTitle->setChecked(centerTitle);
	bool noTitleFrame = m_config->readBoolEntry("NoTitleFraming", false);
	m_dialog->m_noTitleFrame->setChecked(noTitleFrame);
	//
	bool closerWide = m_config->readBoolEntry("WideCloser", false);
	m_dialog->m_closerWide->setOn(closerWide);
	bool menuWide = m_config->readBoolEntry("WideMenu", false);
	m_dialog->m_menuWide->setOn(menuWide);
	bool maxWide = m_config->readBoolEntry("WideMaximizer", false);
	m_dialog->m_maxWide->setOn(maxWide);
	bool minWide = m_config->readBoolEntry("WideMinimizer", false);
	m_dialog->m_minWide->setOn(minWide);
	bool stickyWide = m_config->readBoolEntry("WideSticker", false);
	m_dialog->m_stickyWide->setOn(stickyWide);
	bool aboveWide = m_config->readBoolEntry("WideAbove", false);
	m_dialog->m_aboveWide->setOn(aboveWide);
	bool belowWide = m_config->readBoolEntry("WideBelow", false);
	m_dialog->m_belowWide->setOn(belowWide);
	bool helpWide = m_config->readBoolEntry("WideHelp", false);
	m_dialog->m_helpWide->setOn(helpWide);

	int closerGlow = m_config->readNumEntry("CloserGlow", 0);
	m_dialog->m_closerGlow->setCurrentItem(closerGlow);
	int menuGlow = m_config->readNumEntry("MenuGlow", 2);
	m_dialog->m_menuGlow->setCurrentItem(menuGlow);
	int maxGlow = m_config->readNumEntry("MaximizerGlow", 1);
	m_dialog->m_maxGlow->setCurrentItem(maxGlow);
	int minGlow = m_config->readNumEntry("MinimizerGlow", 3);
	m_dialog->m_minGlow->setCurrentItem(minGlow);
	int stickyGlow = m_config->readNumEntry("StickerGlow", 5);
	m_dialog->m_stickyGlow->setCurrentItem(stickyGlow);
	int aboveGlow = m_config->readNumEntry("AboveGlow", 6);
	m_dialog->m_aboveGlow->setCurrentItem(aboveGlow);
	int belowGlow = m_config->readNumEntry("BelowGlow", 7);
	m_dialog->m_belowGlow->setCurrentItem(belowGlow);
	int helpGlow = m_config->readNumEntry("HelpGlow", 4);
	m_dialog->m_helpGlow->setCurrentItem(helpGlow);
	//
	QColor defaultColor0(255, 0, 0);
	QColor defaultColor1(0, 255, 0);
	QColor defaultColor2(0, 192, 255);
	QColor defaultColor3(255, 160, 0);
	QColor defaultColor4(255, 0, 255);
	QColor defaultColor5(255, 255, 0);
	QColor defaultColor6(128, 128, 128);
	QColor defaultColor7(255, 255, 255);
	//
	QColor color0 = m_config->readColorEntry("Color0", &defaultColor0);
	m_dialog->listColor0->setColor(color0);
	QColor color1 = m_config->readColorEntry("Color1", &defaultColor1);
	m_dialog->listColor1->setColor(color1);
	QColor color2 = m_config->readColorEntry("Color2", &defaultColor2);
	m_dialog->listColor2->setColor(color2);
	QColor color3 = m_config->readColorEntry("Color3", &defaultColor3);
	m_dialog->listColor3->setColor(color3);
	QColor color4 = m_config->readColorEntry("Color4", &defaultColor4);
	m_dialog->listColor4->setColor(color4);
	QColor color5 = m_config->readColorEntry("Color5", &defaultColor5);
	m_dialog->listColor5->setColor(color5);
	QColor color6 = m_config->readColorEntry("Color6", &defaultColor6);
	m_dialog->listColor6->setColor(color6);
	QColor color7 = m_config->readColorEntry("Color7", &defaultColor7);
	m_dialog->listColor7->setColor(color7);
}

void SerenityConfig::save(KConfig*)
{
	m_config->setGroup("General");
	
	m_config->writeEntry("TitlePosition", m_dialog->m_titlePosition->currentItem());
	m_config->writeEntry("UseFrameColor", m_dialog->m_useFrameColor->isChecked());
	m_config->writeEntry("ZenBorder", m_dialog->m_zenBorder->isChecked());
	m_config->writeEntry("MaximizedCorner", m_dialog->m_maxCorner->isChecked());
	m_config->writeEntry("NoMaximizedFrame", m_dialog->m_noMaxFrame->isChecked());
	//
	m_config->writeEntry("TitleSize", m_dialog->m_titleSize->value());
	m_config->writeEntry("ButtonStyle", m_dialog->m_buttonStyle->currentItem());
	m_config->writeEntry("GradientStyle", m_dialog->m_gradientType->currentItem());
	m_config->writeEntry("AlternateSunkenEffect", m_dialog->m_alternateSinking->isChecked());
	m_config->writeEntry("IconTheme", m_dialog->m_iconTheme->currentItem());
	m_config->writeEntry("StyledMenu", m_dialog->m_styledMenu->isChecked());
	m_config->writeEntry("ExtraSpacing", m_dialog->m_extraSpacing->isChecked());
	m_config->writeEntry("CenterTitle", m_dialog->m_centerTitle->isChecked());
	m_config->writeEntry("NoTitleFraming", m_dialog->m_noTitleFrame->isChecked());
	//
	m_config->writeEntry("WideCloser", m_dialog->m_closerWide->isOn());
	m_config->writeEntry("WideMenu", m_dialog->m_menuWide->isOn());
	m_config->writeEntry("WideMaximizer", m_dialog->m_maxWide->isOn());
	m_config->writeEntry("WideMinimizer", m_dialog->m_minWide->isOn());
	m_config->writeEntry("WideSticker", m_dialog->m_stickyWide->isOn());
	m_config->writeEntry("WideAbove", m_dialog->m_aboveWide->isOn());
	m_config->writeEntry("WideBelow", m_dialog->m_belowWide->isOn());
	m_config->writeEntry("WideHelp", m_dialog->m_helpWide->isOn());

	m_config->writeEntry("CloserGlow", m_dialog->m_closerGlow->currentItem());
	m_config->writeEntry("MenuGlow", m_dialog->m_menuGlow->currentItem());
	m_config->writeEntry("MaximizerGlow", m_dialog->m_maxGlow->currentItem());
	m_config->writeEntry("MinimizerGlow", m_dialog->m_minGlow->currentItem());
	m_config->writeEntry("StickerGlow", m_dialog->m_stickyGlow->currentItem());
	m_config->writeEntry("AboveGlow", m_dialog->m_aboveGlow->currentItem());
	m_config->writeEntry("BelowGlow", m_dialog->m_belowGlow->currentItem());
	m_config->writeEntry("HelpGlow", m_dialog->m_helpGlow->currentItem());
	//
	m_config->writeEntry("Color0", m_dialog->listColor0->color());
	m_config->writeEntry("Color1", m_dialog->listColor1->color());
	m_config->writeEntry("Color2", m_dialog->listColor2->color());
	m_config->writeEntry("Color3", m_dialog->listColor3->color());
	m_config->writeEntry("Color4", m_dialog->listColor4->color());
	m_config->writeEntry("Color5", m_dialog->listColor5->color());
	m_config->writeEntry("Color6", m_dialog->listColor6->color());
	m_config->writeEntry("Color7", m_dialog->listColor7->color());
	//
	m_config->sync();
}

void SerenityConfig::defaults()
{
	m_dialog->m_titlePosition->setCurrentItem(0);
	m_dialog->m_useFrameColor->setChecked(false);
	m_dialog->m_zenBorder->setChecked(false);
	m_dialog->m_maxCorner->setChecked(true);
	m_dialog->m_noMaxFrame->setChecked(false);
	//
	m_dialog->m_titleSize->setValue(20);
	m_dialog->m_buttonStyle->setCurrentItem(0);
	m_dialog->m_gradientType->setCurrentItem(0);
	m_dialog->m_alternateSinking->setChecked(false);
	m_dialog->m_iconTheme->setCurrentItem(0);
	m_dialog->m_styledMenu->setChecked(true);
	m_dialog->m_extraSpacing->setChecked(false);
	m_dialog->m_centerTitle->setChecked(true);
	m_dialog->m_noTitleFrame->setChecked(false);
	//
	m_dialog->m_closerWide->setOn(false);
	m_dialog->m_menuWide->setOn(false);
	m_dialog->m_maxWide->setOn(false);
	m_dialog->m_minWide->setOn(false);
	m_dialog->m_stickyWide->setOn(false);
	m_dialog->m_aboveWide->setOn(false);
	m_dialog->m_belowWide->setOn(false);
	m_dialog->m_helpWide->setOn(false);

	m_dialog->m_closerGlow->setCurrentItem(0);
	m_dialog->m_menuGlow->setCurrentItem(2);
	m_dialog->m_maxGlow->setCurrentItem(1);
	m_dialog->m_minGlow->setCurrentItem(3);
	m_dialog->m_stickyGlow->setCurrentItem(5);
	m_dialog->m_aboveGlow->setCurrentItem(6);
	m_dialog->m_belowGlow->setCurrentItem(7);
	m_dialog->m_helpGlow->setCurrentItem(4);
	//
	m_dialog->listColor0->setColor(QColor(255, 0, 0));
	m_dialog->listColor1->setColor(QColor(0, 255, 0));
	m_dialog->listColor2->setColor(QColor(0, 192, 255));
	m_dialog->listColor3->setColor(QColor(255, 160, 0));
	m_dialog->listColor4->setColor(QColor(255, 0, 255));
	m_dialog->listColor5->setColor(QColor(255, 255, 0));
	m_dialog->listColor6->setColor(QColor(128, 128, 128));
	m_dialog->listColor7->setColor(QColor(255, 255, 255));
}

void SerenityConfig::linkedChange()
{
	if ( m_dialog->m_noMaxFrame->isChecked() )
		m_dialog->m_maxCorner->setEnabled(false);
	else
		m_dialog->m_maxCorner->setEnabled(true);
	//
	if ( (m_dialog->m_buttonStyle->currentItem() == 1) 
	|| (m_dialog->m_buttonStyle->currentItem() == 7) )
	{
		m_dialog->m_noTitleFrame->setEnabled(false);
	}
	else
	{
		m_dialog->m_noTitleFrame->setEnabled(true);
	}
	//
	emit changed();
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
	QObject* allocate_config(KConfig* config, QWidget* parent)
	{
		return (new SerenityConfig(config, parent));
	}
}

#include "serenityconfig.moc"
