//
// C++ Interface: serenityhandler
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SERENITYHANDLER_H
#define SERENITYHANDLER_H

#include <kdecorationfactory.h>
#include <kdecoration.h>
#include <qobject.h>
#include <kconfig.h>

// Default button layout
const char default_left[]  = "M";
const char default_right[] = "HIAX";

class SerenityHandler : public QObject, public KDecorationFactory
{
Q_OBJECT
public:
	SerenityHandler();
	~SerenityHandler();
	virtual bool reset(unsigned long changed);

	virtual KDecoration* createDecoration(KDecorationBridge*);
#if KDE_IS_VERSION(3, 4, 0)
	virtual bool supports( Ability ability );
#endif

	static bool initialized() { return m_initialized; }
	static int borderSize() { return m_borderSize; }	// Fixed value.
	static int titlePosition() { return m_titlePosition; }
	static bool useFrameColor() { return m_useFrameColor; }
	static bool zenBorder() { return m_zenBorder; }
	static bool maxCorner() { return m_maxCorner; }
	static bool noMaxFrame() { return m_noMaxFrame; }
	static int gradientContrast() { return m_gradientContrast; }
	static int titleSize() { return m_titleSize; }
	static int buttonSize() { return m_titleSize; }		// This is on purpose!
	static int buttonSpacing() { return m_borderSize; }
	static int buttonStyle() { return m_buttonStyle; }
	static int iconTheme() { return m_iconTheme; }
	static bool styledMenu() { return m_styledMenu; }
	static int extraSpacing() { return m_extraSpacing ? 2 : 0; }
	static int gradientType() { return m_gradientType; }
	static bool alternateSinking() { return m_alternateSinking; }
	static bool centerTitle() { return m_centerTitle; }
	static bool noTitleFrame() { return m_noTitleFrame; }
	//
	static bool closeWide() { return m_closerWide; }
	static bool menuWide() { return m_menuWide; }
	static bool maxWide() { return m_maxWide; }
	static bool minWide() { return m_minWide; }
	static bool stickyWide() { return m_stickyWide; }
	static bool aboveWide() { return m_aboveWide; }
	static bool belowWide() { return m_belowWide; }
	static bool helpWide() { return m_helpWide; }

	static int closeGlow() { return m_closerGlow; }
	static int menuGlow() { return m_menuGlow; }
	static int maxGlow() { return m_maxGlow; }
	static int minGlow() { return m_minGlow; }
	static int stickyGlow() { return m_stickyGlow; }
	static int aboveGlow() { return m_aboveGlow; }
	static int belowGlow() { return m_belowGlow; }
	static int helpGlow() { return m_helpGlow; }
	//
	static QColor listColor(int idx)
	{
		switch(idx)
		{
			case 0: return listColor0;
			case 1: return listColor1;
			case 2: return listColor2;
			case 3: return listColor3;
			case 4: return listColor4;
			case 5: return listColor5;
			case 6: return listColor6;
			case 7: return listColor7;
			default: return listColor0;
		}
	}

private:
	static bool m_initialized;
	static int m_titlePosition;
	static bool m_useFrameColor;
	static bool m_zenBorder;
	static bool m_maxCorner;
	static bool m_noMaxFrame;
	static int m_gradientContrast;
	static int m_titleSize;
	static int m_buttonSize;
	static int m_buttonStyle;
	static int m_gradientType;
	static bool m_alternateSinking;
	static int m_iconTheme;
	static bool m_styledMenu;
	static bool m_extraSpacing;
	static bool m_centerTitle;
	static bool m_noTitleFrame;
	//
	static int m_borderSize;
	//
	static bool m_closerWide;
	static bool m_menuWide;
	static bool m_maxWide;
	static bool m_minWide;
	static bool m_stickyWide;
	static bool m_aboveWide;
	static bool m_belowWide;
	static bool m_helpWide;

	static int m_closerGlow;
	static int m_menuGlow;
	static int m_maxGlow;
	static int m_minGlow;
	static int m_stickyGlow;
	static int m_aboveGlow;
	static int m_belowGlow;
	static int m_helpGlow;
	//
	static QColor listColor0;
	static QColor listColor1;
	static QColor listColor2;
	static QColor listColor3;
	static QColor listColor4;
	static QColor listColor5;
	static QColor listColor6;
	static QColor listColor7;
	//
	void readConfig();
};

#endif
