#ifndef KDIALUP_H
#define KDIALUP_H
/** Kwlan
 *
 *  This File is part of Kwlan, a network Manager for KDE.
 *  Kwlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include <qobject.h> 

class KProcess;
class KwlanTrayWin;
class KwlanInterface;

class QString;
//class KwlanSuProcess;
//class KProcess;

class KDialup : public QObject
{
    Q_OBJECT
        
        
    public:
        KDialup(QObject * parent = 0, const char * name = 0 );
        ~KDialup();
    signals:
        void logEvent(QString event);
        void connectionEstablished();
        
    public slots:
        void connectNetwork(QString network);
        void slotConnect();
        void disconnectNetwork(QString network);
        void pppdStatus(KProcess *proc, char *buffer, int buflen);
        void interfaceEnable(bool enable);
        void close();
        void slotProcessExited(KProcess *);
    private:
        bool m_connected;
        bool m_storePassword;
        bool m_connecting;
        QString m_pppdPath;
        QString m_pppInterface;
        QString m_network;
        KwlanTrayWin *m_traywin;
        KwlanInterface *m_interface;


};

#endif
