#ifndef KWLANINTERFACE_H
#define KWLANINTERFACE_H
/** Kwlan
 *
 *  This File is part of Kwlan, a network Manager for KDE.
 *  Kwlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kwlan.h"
#include "wpa_ctrl.h"
#include "wpamsg.h"
#include "kuserdatarequestdlg.h"
#include "configuration.h"
#include "kwlansuprocess.h"


#include <kapplication.h>
#include <qsocketnotifier.h>
#include <wlanlib.h>
#include <arpa/inet.h>

#undef __STRICT_ANSI__
#include <linux/netdevice.h>
#define __STRICT_ANSI__

class QString;
class QStringList;
class KTempFile;
class KProcess;
class KEventHistoryDlg;
class KScanDlg;
class KwlanTrayWin;

class KwlanInterface  : public QObject
{
    Q_OBJECT
    public:
        KwlanInterface();
        ~KwlanInterface();
        enum InterfaceState
        {
            UNKNOWN_STATE = -1,
            NOT_EXISTING  = 0,
            NOT_AVAILABLE = 1,
            AVAILABLE     = 2,
            RX_TRAFFIC    = 4,
            TX_TRAFFIC    = 8
        };

        enum InterfaceType
        {
            UNKNOWN_TYPE = -1,
            ETHERNET = 0,
            PPP = 1
        };
        void setType( int type )
        {
            m_type = type;
        }

        int getType()
        {
            return m_type;
        }

        void setState( int state )
        {
            m_state = state;
        }

        int getState()
        {
            return m_state;
        }
        interfaceData getInterfaceData()
        {
            if ( m_interfaceData.wirelessDevice && m_wirelessData.radioOff )
            m_interfaceData.connected = FALSE;
            return m_interfaceData;
        }
        wirelessData getWirelessData()
        {
            return m_wirelessData;
        }
        QString getCurrentProfile()
        {
            return m_ssid;
        }
        QString getConfFile()
        {
            return m_confFile;
        }
        Configuration *getConfiguration()
        {
            return m_configuration;
        }
        void setConfiguration(Configuration *config)
        {
            m_configuration = config;
        }
        bool hasControlConnection()
        {
            if (m_controlConnection) return TRUE;
            return FALSE;
        }
        wpa_ctrl *getControlConnection()
        {
            return m_controlConnection;
        }
        bool getWpaStarted()
        {
            return m_wpaStarted;
        }
        bool getConfigureInterface()
        {
            return m_configureInterface;
        }
        bool profileActivateNonWpa(QString ssid);
        bool profileActivateWpa(QString ssid);
        void startScriptAfterConnect();
        void setNetworkSettings();
        void checkType();
        
    public slots:
        void init(QString interface);
        void slotWpaStatusChanged(bool status);
        int  openControlConnection();
        void checkConnection();
        int  ctrlRequest(const char *command, char *bur, size_t *buflen);
        bool hasProfiles();
        QStringList listProfiles();
        QStringList listWpaProfiles();
        QStringList listNonWpaProfiles(QStringList wpaProfiles);
        int getWpaId(QString ssid);
        bool profileActivate(QString ssid);
        void releaseIpAddress();
        void getIpAddress();
        void processMessage(char *message);
        void receiveMsgs();
        void processCtrlReq( const char * request );
        void startWpa(QString driver);
        void stopWpa();
        QString getInterfaceName();
        void profileAdded();
        void iwconfigProcessExited( KProcess* process );
        void iwconfigProcessStdout( KProcess*, char* buffer, int buflen );
        void dhcpProcessExited(KwlanSuProcess *);
        void releaseProcessExited(KwlanSuProcess *);
        //void iwconfigProcessExited( KProcess* process );
        //void iwconfigProcessStdout( KProcess* process, char* buffer, int buflen );
        void checkConfig();
        void logViewer();
        void enableInterface(bool enable);
        void editProfiles();
        void slotScan();
        void slotNewProfile();
        void slotEditProfile(QString profile);
        void slotDeleteProfile(QString profile);
        void slotEnableConfigureInterface(QString, bool);

    signals:
        void wpaStatusChanged(bool started);
        void connectionStatusChanged (bool connected);
        void networksChanged();
        void ipChanged(QString ip);
        void wpaEvent( WpaMsg msg );
        void wpaEvents( WpaMsgList msgs );
        void interfaceUp(bool up);
        void interfaceGone(KwlanInterface *interface);
        void sigMessage(QString message);
        
    private:
        char *m_controlInterface,*m_controlInterfaceDir;
        wpa_ctrl *m_controlConnection, *m_monitorConnection;
        WpaMsgList m_messages;
        QSocketNotifier *m_messageNotifier;
        bool m_networkChange;
        bool m_startDhclient;
        bool m_associated;
        bool m_IpAddress;
        bool m_wpaStarted;
        bool m_useDhclient;
        bool m_useDhcpcd;
        bool m_dhcpEnabled;
        bool m_wpaWarned; // User has been warned in case of failure to connect to wpa_supplicant
        bool m_ipConfigured;
        bool m_configureInterface;
        QString m_ssid;
        QString m_staticIpAddress,  m_staticGateway, m_staticNetmask;
        QString m_staticDns1, m_staticDns2, m_domain;
        bool m_dontOverrideDns, m_dontOverrideGw;
        QStringList m_dnsSearchlist;
        QString m_dhclientPath, m_dhcpcdPath, m_wpaPath; //Path to external applications that are frequently used
        QString m_ifconfigPath, m_iwconfigPath;
        QString m_wpaConf; // path to wpa_supplicant config file for this interface;
        QTimer *m_timer;
        KUserDataRequestDlg *m_userDataRequest;
        KTempFile *resolvconf;
        interfaceData m_interfaceData;
        wirelessData m_wirelessData;
        QString m_ifconfigStdout, m_iwconfigStdout;
        KProcess *m_ifconfigProcess, *m_iwconfigProcess;
        int m_type;
        int m_state;
        QString m_confFile;
        Configuration *m_configuration;
        KEventHistoryDlg *m_eventHistory;
        KScanDlg *m_scanDlg;
        KwlanTrayWin *m_trayWin;
        QString m_sysClassPath;
        int m_fdSock;
        struct ifreq m_devInfo;
        //KwlanSuProcess *m_dhcpProcess;
        KwlanSuProcess *m_dhcpProcess;
        KwlanSuProcess *m_releaseProcess;
        
        void parseIwconfigOutput();
        void updateInterfaceData( QString& config,  int type );
        void updateWirelessData( QString& config );
        void getIpData();
        unsigned long readInterfaceNumValue(const char *name);
        bool openFdSocket();
        void say(QString message);
        void newInterfaceWizard(QString interface);

    private slots:
        void cleanTemporaryFiles();
        
};

#endif
