

#include "kwlansettingsdlg.h"
#include "configuration.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kfiledialog.h>

KwlanSettingsDlg::KwlanSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KwlanSettings(parent,name, modal,fl)
{
    m_configuration = 0L;
}

KwlanSettingsDlg::~KwlanSettingsDlg()
{
}

/*$SPECIALIZATION$*/
void KwlanSettingsDlg::enableWpaNoQuestion(int state)
{
    cbWpaNoQuestion->setEnabled(state);
}
void KwlanSettingsDlg::customWpaConfigChanged(int state)
{
    leConfigFile->setEnabled(state);
    pbBrowseConfigFile->setEnabled(state);
}

void KwlanSettingsDlg::browseConfigFile()
{
    QString file = KFileDialog::getOpenFileName ();
    if (!file.isEmpty())
        leConfigFile->setText(file);
}

void KwlanSettingsDlg::Cancel()
{
    QWidget::close(true);
}

void KwlanSettingsDlg::Ok()
{
    if (!m_configuration)
    {
        QWidget::close(true);
        return;
    }
    m_configuration->m_startWpa = cbWpa->isChecked();
    m_configuration->m_startWpaNoQuestion = cbWpaNoQuestion->isChecked();
    m_configuration->m_useCustomWpaConf = cbUseCustomConfigFile->isChecked();
    m_configuration->m_customWpaConf = leConfigFile->text();
    m_configuration->writeSettings();
    QWidget::close(true);
}

void KwlanSettingsDlg::setConfiguraton(Configuration *conf)
{
    m_configuration = conf;
    if (!conf) return;
    cbWpa->setChecked(m_configuration->m_startWpa);
    cbWpaNoQuestion->setChecked(m_configuration->m_startWpaNoQuestion);
    cbUseCustomConfigFile->setChecked(m_configuration->m_useCustomWpaConf);
    leConfigFile->setText(m_configuration->m_customWpaConf);

}

#include "kwlansettingsdlg.moc"

