/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_ANIMATOR_H
#define XEPLUGIN_ANIMATOR_H

#include <qobject.h>
#include <qstring.h>
#include <qmutex.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <qptrlist.h>
#include <time.h>

class XGIcon;
class XSConfigurations;
class XEConfiguration;
class XGDocker;
class QTimer;
class xGFloater;


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_Animator : public QObject
{
Q_OBJECT
public:
    XEPlugin_Animator(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_Animator();
public slots:
    void xSetup();
    void xStop();
    void xEventMouseClick(int,int,int,int);
    void xStart();
    void xEventRemoveIcon(int);
    void xGetParameter(const QString, QString&);
    void xGetParameterList(QStringList *);
    void xSetupParameter(const QString, const QString);
    void xEventDockerShowed();
    void xEventDockerHidden();
    void xParse(const QString &, int, void *);
    void xEventRemovingIcon(int,int);
    void xEventStartupRemoved(int);
    void xEventStartupAdded(int);
protected slots:
    void xAnimateDockerSlideRight(int,int,int,int,int,int,int,int);
    void xAnimateBounce(XGIcon *);
    void xAnimateMicro(XGIcon *);
    void xEventTaskOpen(int);
    void xEventReset(int,int);
    void xAnimate();
    void xEventAnimateTo(int,int,int,int);
    void xAnimateTo();
    void xAnimateStepBounce();
    void xAnimateStepMicro();
    void xGetInfo(QStringList &);
    void xStopAnimate();
    void xStartAnimate(XGIcon *);
    void xStartAnimate();
    void xAnimateStepBounceDetached();
    void xEventIconAdded(int);
    void xAnimateStepFadeIcon();
    void xAnimateFadeIcon(XGIcon *);
    void xAnimateStepOverlay();
    void xEventHighlightIcon(int,void *);
    void xEventTaskClosed(int);
protected:
	timespec	req,rem;
	XEConfiguration *Configurator;
	XSConfigurations *ActiveConfiguration;
	XGDocker	*xGDocker;
	double radians;
	QPoint mouse;
	QPoint mousef;
	int moltiplier;
	int lastRaise;
	int animatorCounter;
	int BounceHigh;
	int	highlightAnimation;
	//int Counter;
	XGIcon		*lastIcon;
	QPtrList<XGIcon> lastIcons;
	QTimer		*bounceTimer;
	QTimer		*fadeTimer;
	QTimer		*bounceDetachedTimer;
	QTimer		*overlayPollTimer;
	xGFloater *LocalDetachedWindow;
	QMutex		AnimationsMutex;
	
	QString		onClickAnimation;
	QString		onRaiseAnimation;
	QString		onCloseAnimation;
	QString		onHideAnimation;
	QString		onShowAnimation;
	QString		onAddAnimation;
	QString		onSlideAnimation;

	XGIcon		*animatingIcon;
protected:
    void xAnimateDockerSlideShow();
    void xAnimateDockerFadeShow();
    void xAnimateDockerFadeHide();
    void xAnimateDockerSlideHide();
    void xAnimateOverlay(XGIcon *);
public:
signals:
    void xEventStartAnimating(const QString &);
    void xEventStopAnimating(const QString &);
};

#endif
