/***************************************************************************
                          kxesearchdialog.h  -  description
                          -----------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXESEARCHDIALOG_H
#define KXESEARCHDIALOG_H

#include "kxesearchdialogbase.h"

#include <qlineedit.h>
#include <qcheckbox.h>

/**
 * Dialog for input information from user
 * about searching in XML document
 */
// TODO add possibility to search backwards
class KXESearchDialog : public KXESearchDialogBase
{
		Q_OBJECT

	public:
		KXESearchDialog( QWidget * pParent, const char * pszName = 0, bool bModal = true );

		QString getSearchString() const { return m_pEditSearchedString->text(); }
		bool getMatchCase() const { return m_pCheckBoxMatchCase->isChecked(); }
		bool getInElementNames() const { return m_pCheckBoxElementNames->isChecked(); }
		bool getInAttributeNames() const { return m_pCheckBoxAttributeNames->isChecked(); }
		bool getInAttributeValues() const { return m_pCheckBoxAttributeValues->isChecked(); }
		bool getInContents() const { return m_pCheckBoxContents->isChecked(); }

	protected:
		/** Enables/Disables the "Find"-button. */
		void toggleAcceptButton();

	protected slots:
		/** Called when text in edit line is changed */
		virtual void slotTextChanged(const QString & );

    /** Called on a change of the "find in" checkbuttons. */
		virtual void slotFindInChanged();
};

#endif
