/***************************************************************************
 *   Copyright (C) 2006 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PALETTEMANAGER_H
#define PALETTEMANAGER_H

#include "palettemanagerdlg.h"

class CharSelectorDialog;
class FlossPalette;
class Floss;
class FlossListBoxItem;
class QListBox;
class QListBoxItem;

class PaletteManagerDialog : public PaletteManagerDlg
{
  Q_OBJECT
public:
  PaletteManagerDialog(QWidget* parent, FlossPalette* palette, QValueList<int> usedColors);
  virtual ~PaletteManagerDialog();

protected slots:
  virtual void accept();
  void contextHelp();
  void addFloss();
  void removeFloss();
  void swapFlosses();
  void selectSymbol();
  void schemeSelectionChanged(QListBoxItem*);
  void currentSelectionChanged(QListBoxItem*);
  void stitchStrandsChanged(int);
  void backstitchStrandsChanged(int);
  void newColor();
  void removeUnused();
  void calibrateColors();

private:
  /** fill SchemeFlosses list with flosses from selected scheme
    */
  void fillColorList();
  void fillCurrentList();
  bool contains(QString);
  int index(QString);
  int index(Floss*);
  void insertFlossListBoxItem(QListBox*, FlossListBoxItem*);
  QChar freeSymbol();
  int freeIndex();

  QString             m_scheme;
  QString             m_font;
  QChar               m_selectedChar;
  FlossPalette*       m_currentPalette;
  QValueList<int>     m_usedFlosses;
  CharSelectorDialog* m_charTable;
  QMap<int,Floss*>    m_flosses;
  QMap<int,QChar>     m_symbols;
  QMap<int,int>       m_stitchStrands;
  QMap<int,int>       m_backstitchStrands;
};

#endif
