/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PRINTDLGPAGE_H
#define PRINTDLGPAGE_H

#include <kdeprint/kprintdialogpage.h>
#include "printdlg.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QComboBox;
class QLabel;
class QSpinBox;
class KPrinter;
class PrintDlgUI;

/** Print dialog page for KXStitch specific options
    @author Stephen P Allewell
  */
class PrintDlgPage : public KPrintDialogPage {
  Q_OBJECT
public:
/** Constructor
    @param prn Pointer to the KPrinter object.
    @param cells The width and height of the pattern to be printed.
    @param parent Parent QWidget.
    @param name Internal name for this widget.
  */
  PrintDlgPage(KPrinter* prn, QSize cells, QWidget* parent = 0, const char* name = 0);

/** Reimplemented from base class.
    Fill the structure opts with the values in the dialog.
    @param opts QMap of QString key and QString values to store dialog box values.
    @param incldefs TRUE if default values should be included in the map,
    FALSE (default) otherwise.
  */
  virtual void getOptions(QMap<QString,QString>& opts, bool incldef = false);
/** Reimplemented from base class.
    Set the values for the dialog to those in the structure opts.
    @param opts QMap of QString key and QString values to store dialog box values.
  */
  virtual void setOptions(const QMap<QString,QString>& opts);
/** Reimplemented from base class.
    Checks the values in the dialog box are valid.
    @return TRUE if the options are valid, FALSE otherwise.
    @param msg Reference to a QString to store an error message
    if returning false.
  */
  virtual bool isValid(QString& msg);
/** Reimplemented from base class.
    @return The minimum size required to contain the elements of the page.
  */
  virtual QSize minimumSizeHint() const;

private:
  KPrinter*   m_printer;
  QSize       m_gridSize;
  PrintDlgUI* m_dlg;
};

#endif
