/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
using namespace std;

#include "choicebox.h"

choicebox::choicebox(QStringList *choices)
{
  selected=QString::null;
  this->setCaption(i18n("Select correct disc"));
  this->setModal(TRUE);
  choiceboxlayout=new QVBoxLayout(this);
  QSize listviewsize(500,200);
  choicelistbox=new QListView(this);
  choicelistbox->setSelectionMode(QListView::Single);
  choicelistbox->setRootIsDecorated(FALSE);
  choicelistbox->setResizeMode(QListView::AllColumns);
  choicelistbox->addColumn(i18n("Tags from CDDB"),-1);
  choicelistbox->setMinimumSize(listviewsize);
  okbutton=new QPushButton(i18n("Ok"),this);
  choiceboxlayout->addWidget(choicelistbox);
  choiceboxlayout->addWidget(okbutton);
  QStringList::Iterator index=choices->begin();
  while(index!=choices->end())
    {
      //add all choices into listview
      new QListViewItem(choicelistbox,*index);
      index++;
    }
  this->show();
  connect (okbutton,SIGNAL(clicked()),SLOT(selectcd()));
}

void choicebox::selectcd()
{
  //check if user marked something
  if (choicelistbox->selectedItem())
    {
      selected=choicelistbox->selectedItem()->text(0);
      this->close();
    }
}
