/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cleanup.h"

extern rcdatei settingsfile;

cleanup::cleanup(QWidget *pointer)
{
  parent=pointer;
  url=new QUrlOperator();
  abort=FALSE;
  directoriesok=FALSE;
  goodfiles=0;
  badfiles=0;
  QDir *actualdirectory=new QDir();
  progresswindow=new progressmainwindow(FALSE);
  progresswindow->show();
  progressinfo *initmessage=progresswindow->startInfo(i18n("Checking directories"));
  //First of all, check if directories are ok
  QFileInfo filecheck(settingsfile.destination_dir);
  if (!filecheck.exists())
    {
      QMessageBox::warning(parent,i18n("Access error"),i18n("The destination directory doesn't exist"),"&Ok",QString::null,QString::null,1);
      return;
    }
  else
    {
      if (!filecheck.isWritable())
        {
          QMessageBox::warning(parent,i18n("Access error"),i18n("You have no writeprivilegs for the  destination directory"),"&Ok",QString::null,QString::null,1);
          return;
        }
    }
  filecheck=QFileInfo(settingsfile.reject_dir);
  if (!filecheck.exists())
    {
      QMessageBox::warning(parent,i18n("Access error"),i18n("The reject directory doesn't exist"),"&Ok",QString::null,QString::null,1);
      return;
    }
  else
    {
      if (!filecheck.isWritable())
        {
          QMessageBox::warning(parent,i18n("Access error"),i18n("You have no writeprivilegs for the reject directory"),"&Ok",QString::null,QString::null,1);
          return;
        }
    }
  directoriesok=TRUE;
  //split up filter,and check if ok
  initmessage->setText(i18n("Checking filters"));
  cleanupfilter=new filter(settingsfile.filter,settingsfile.reading_dir);
  if (!cleanupfilter->filterOk)
    {
      abort=TRUE;
      QMessageBox::warning(parent,i18n("Filter-error"),cleanupfilter->errorText,"&Ok",QString::null,QString::null,1);
    }
  else
    filterok=TRUE;
  progresswindow->killProgress(initmessage);
}


void cleanup::cleanupdir(QStringList *selectedFiles,long counter)
{
  progresswithbar *cleanupprogress=progresswindow->startProgress(i18n("Cleaning up files"),counter);
  connect (cleanupprogress,SIGNAL(chancelled()),SLOT(abortslot()));
  QStringList::Iterator index=selectedFiles->begin();
  long runningcounter=0;
  while (index!=selectedFiles->end()&&!abort)
    {
      cleanupprogress->setProgress(++runningcounter);
      QString filename=*index;
      QString newfilename;
      int status=cleanupfilter->makeDirectories(filename,settingsfile.destination_dir);
      if (status==-1)
        {
          abort=TRUE;
          QMessageBox::warning(parent,i18n("Process chanceled"),cleanupfilter->errorText,"&Ok",QString::null,QString::null,1);
        }
      else if (status==0)
        {
          badfiles++;
          int position=filename.findRev("/");
          newfilename=QString("%1%2").arg(settingsfile.reject_dir,filename.right(filename.length()-(position+1)));
        }
      //berprfen, ob Datei schon existiert
      else if (status==1)
        {
          status=cleanupfilter->generateName(filename);
          if (status==-1)
            {
              abort=TRUE;
              QMessageBox::warning(parent,i18n("Process chanceled"),cleanupfilter->errorText,"&Ok",QString::null,QString::null,1);
            }
          if (status==0)
            {
              //no good tags, move to reject
              badfiles++;
              int position=filename.findRev("/");
              newfilename=QString("%1%2").arg(settingsfile.reject_dir,filename.right(filename.length()-(position+1)));
            }
        }
      if (status==1)
        {
          goodfiles++;
          newfilename=QString("%1%2.%3").arg(settingsfile.destination_dir,cleanupfilter->filenamesuggest,QString(*index).right(3));
        }
      QFileInfo filecheck(newfilename);
      if (!filecheck.exists())
        {
          if (!settingsfile.loeschen)
            {
              url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
            }
          else
            {
              QFileInfo movecheck(filename);
              if (movecheck.isWritable())
                {
                  url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                  connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                  notcopied=TRUE;
                  while (notcopied)
                    kapp->processEvents();
                  QDir transaction;
                  transaction.remove(filename);
                  checkdirempty(filename);
                }
              else
                {
                  QString message=QString(i18n("File %1 is writeprotected.<br>File will be copied only, if you press OK.")).arg(filename);
                  if (QMessageBox::warning(parent,i18n("Delete error"),message,"&Ok",i18n("&Chancel"),QString::null,1))
                    abort=TRUE;
                  else
                    url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                  connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                  notcopied=TRUE;
                  while (notcopied)
                    kapp->processEvents();
                }
            }
        }
      else
        {
          if (settingsfile.ueberschreiben)
            {
              if (settingsfile.besser)
                {
                  musikdatei datei;
                  id3tag *newSong=datei.lesenTag(filename);
                  id3tag *oldSong=datei.lesenTag(newfilename);
                  if (newSong->bitrate>oldSong->bitrate)
                    {
                      if (!settingsfile.loeschen)
                        {
                          url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                          connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                          notcopied=TRUE;
                          while (notcopied)
                            kapp->processEvents();
                          disconnect(url,SIGNAL(finished(QNetworkOperation *)),this,SLOT(copyfinished()));
                        }
                      else
                        {
                          QFileInfo movecheck(filename);
                          if (movecheck.isWritable())
                            {
                              url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                              connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                              notcopied=TRUE;
                              while (notcopied)
                                kapp->processEvents();
                              disconnect(url,SIGNAL(finished(QNetworkOperation *)),this,SLOT(copyfinished()));
                              QDir transaction;
                              transaction.remove(filename);
                              checkdirempty(filename);
                            }
                          else
                            {
                              QString message=QString(i18n("File %1 is writeprotected.<br>File will be copied only, if you press OK.")).arg(filename);
                              if (QMessageBox::warning(parent,i18n("Delete error"),message,"&Ok",i18n("&Chancel"),QString::null,1))
                                abort=TRUE;
                              else
                                url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                              connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                              notcopied=TRUE;
                              while (notcopied)
                                kapp->processEvents();
                              disconnect(url,SIGNAL(finished(QNetworkOperation *)),this,SLOT(copyfinished()));
                            }
                        }
                    }
                  else //Bitrate less or equal. Check if we need to delete original
                    {
                      if (settingsfile.loeschen)
                        {
                          QFileInfo movecheck(filename);
                          if (movecheck.isWritable())
                            {
                              QDir transaction;
                              transaction.remove(filename);
                              checkdirempty(filename);
                            }
                          else
                            {
                              QString message=QString(i18n("File %1 is writeprotected.<br>File will be copied only, if you press OK.")).arg(filename);
                              if (QMessageBox::warning(parent,i18n("Delete error"),message,"&Ok",i18n("&Chancel"),QString::null,1))
                                abort=TRUE;
                            }
                        }
                    }
                  delete oldSong;
                  delete newSong;
                }
              else
                {
                  if (!settingsfile.loeschen)
                    {
                      url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                      connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                      notcopied=TRUE;
                      while (notcopied)
                        kapp->processEvents();
                      disconnect(url,SIGNAL(finished(QNetworkOperation *)),this,SLOT(copyfinished()));
                    }
                  else
                    {
                      QString message=QString(i18n("File %1 is writeprotected.<br>File will be copied only, if you press OK.")).arg(filename);
                      if (QMessageBox::warning(parent,i18n("Delete error"),message,"&Ok",i18n("&Chancel"),QString::null,1))
                        abort=TRUE;
                      else
                        url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                      connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                      notcopied=TRUE;
                      while (notcopied)
                        kapp->processEvents();
                      disconnect(url,SIGNAL(finished(QNetworkOperation *)),this,SLOT(copyfinished()));
                    }
                }
            }
        }
      ++index;
    }
  delete progresswindow;
  if (goodfiles>0||badfiles>0)
    {
      QString erfolg=QString(i18n("%1 files recognized as propper tagged. %2 files have incomplete or missing tags.")).arg(QString::number(goodfiles),QString::number(badfiles));
      QMessageBox::information(parent,i18n("Process ready"),erfolg,"&Ok");
    }
}

void cleanup::cleanupcd(QStringList *selectedFiles,long counter)
{
  progresswithbar *cleanupprogress=progresswindow->startProgress(i18n("Cleaning up files"),counter);
  connect (cleanupprogress,SIGNAL(chancelled()),SLOT(abortslot()));
  QStringList::Iterator index=selectedFiles->begin();
  long runningcounter=0;
  while (index!=selectedFiles->end()&&!abort)
    {
      cleanupprogress->setProgress(++runningcounter);
      QString filename=*index;
      QString newfilename;
      int status=cleanupfilter->makeDirectories(filename,settingsfile.destination_dir);
      if (status==-1)
        {
          abort=TRUE;
          QString errormessage=QString(i18n("%1<br>The ripped files will stay in the <b>Temp-directory!")).arg(cleanupfilter->errorText);
          QMessageBox::warning(parent,i18n("Process chanceled"),errormessage,"&Ok",QString::null,QString::null,1);
        }
      else
        {
          status=cleanupfilter->generateName(filename);
          if (status==-1)
            {
              abort=TRUE;
              QString errormessage=QString(i18n("%1<br>The ripped files will stay in the <b>Temp-directory!")).arg(cleanupfilter->errorText);
              QMessageBox::warning(parent,i18n("Process chanceled"),errormessage,"&Ok",QString::null,QString::null,1);
            }
          else
            {
              newfilename=QString("%1%2.%3").arg(settingsfile.destination_dir,cleanupfilter->filenamesuggest,QString(*index).right(3));
              QFileInfo filecheck(newfilename);
              if (!filecheck.exists())
                {
                  url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                  connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                  notcopied=TRUE;
                  while (notcopied)
                    kapp->processEvents();
                  QDir transaction;
                  transaction.remove(filename);
                }
              else
                {
                  if (settingsfile.ueberschreiben)
                    {
                      if (settingsfile.besser)
                        {
                          musikdatei datei;
                          id3tag *newSong=datei.lesenTag(filename);
                          id3tag *oldSong=datei.lesenTag(newfilename);
                          if (newSong->bitrate>=oldSong->bitrate)
                            {
                              QFileInfo movecheck(newfilename);
                              if (movecheck.isWritable())
                                {
                                  url->copy(filename,newfilename.local8Bit(),FALSE,FALSE);
                                  connect(url,SIGNAL(finished(QNetworkOperation *)),SLOT(copyfinished()));
                                  notcopied=TRUE;
                                  while (notcopied)
                                    kapp->processEvents();
                                  disconnect(url,SIGNAL(finished(QNetworkOperation *)),this,SLOT(copyfinished()));
                                  QDir transaction;
                                  transaction.remove(filename);
                                }
                              else
                                {
                                  QString message=QString(i18n("File %1 is already existing and writeprotected.<br>The ripped files will stay in the <b>Temp-directory!")).arg(newfilename);
                                  QMessageBox::warning(parent,i18n("Overwrite-error"),message,"&Ok",i18n("&Chancel"),QString::null,1);
                                  abort=TRUE;
                                }
                            }
                          else
                            {
                              QDir transaction;
                              transaction.remove(filename);
                            }
                        }
                      else //Bitrate less or equal. Check if we need to delete original
                        {
                          QDir transaction;
                          transaction.remove(filename);
                        }
                    }
                  else
                    {
                      QDir transaction;
                      transaction.remove(filename);
                    }
                }
            }
        }
      index++;
    }
  delete progresswindow;
}

void cleanup::abortslot()
{
  abort=TRUE;
}

void cleanup::checkdirempty(QString file)
{
  //extract directoryname out of filename
  QString cleandir=file.left(file.findRev('/'));
  QDir *checkdir=new QDir();
  checkdir->setCurrent(cleandir);
  checkdir->setNameFilter("*");
  QStringList buffer=checkdir->entryList();
  QStringList::Iterator index=buffer.begin();
  int counter=0;
  while (index!=buffer.end())
    {
      index++;
      counter++;
    }
  if (!(counter>2))
    {
      //if directory is empty (except the /. and /.. entry), check if we are still not in startdir
      if (cleandir.compare(settingsfile.reading_dir.left(settingsfile.reading_dir.length()-1)))
        checkdir->rmdir(cleandir);
      checkdirempty(cleandir);//recursively check the next lower dir, untill startdir is reached
    }
}

void cleanup::copyfinished()
{
  notcopied=FALSE;
}
