/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <iostream>

using namespace std;

#include "tableiste.h"
#include "rcdatei.h"

#include "mysqlinterface.h"

#include "cdidgenerator.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "filter.h"

//globale Variablen

mysqldatabase *database;
musikdatei *datei;
verzeichnis *verzeichnisbaum;
rcdatei settingsfile;

static const char description[] =
  I18N_NOOP("A KDE KPart Application");

static const char version[] = "0.2a";

static KCmdLineOptions options[] =
  {
    //    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
  };

int main( int argc, char ** argv )
{
//cdrominfo *cdtoc=new cdrominfo(); 
  KAboutData about("kyamo", I18N_NOOP("kyamo"), version, description,
                   KAboutData::License_GPL, "(C) 2005 Roland Weigert", 0, 0, "roweigert@t-online.de");
  about.addAuthor( "Roland Weigert", 0, "roweigert@t-online.de" );
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options );
  KApplication programm(argc,argv);
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  settingsfile.laden();
  if (settingsfile.mysql)
    {
      //datenbank=new mysqldatenbank();//datenbank initialisieren, und bei Bedarf erstellen
      mysqldatabase *database=new mysqldatabase();//datenbank initialisieren, und bei Bedarf erstellen
      if(database->quit)
        settingsfile.mysql=FALSE;
    }
  tableiste *Hauptfenster=new tableiste();
  programm.setMainWidget( Hauptfenster );
  Hauptfenster->show();
  args->clear();
  // Hauptfenster has WDestructiveClose flag by default, so it will delete itself.
  return programm.exec();
  if (database)
    delete database;
  delete Hauptfenster;
}
